/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.generator;

import com.jpattern.logger.ILogger;
import com.jpattern.org.cojen.classfile.CodeBuilder;
import com.jpattern.org.cojen.classfile.LocalVariable;
import com.jpattern.org.cojen.classfile.TypeDesc;
import com.jpattern.orm.logger.OrmLogger;
import com.jpattern.orm.mapper.IClassMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class GetterDumpFactory {
    private static Map<Class<?>, Class<?>> primitiveClassMap = null;
    private ILogger logger = OrmLogger.getOrmLogger(this.getClass());

    public void visit(CodeBuilder codeBuilder, int progressive, LocalVariable var, IClassMapper<?> classMapper, String columnName) {
        if (primitiveClassMap == null) {
            this.initPrimitiveClassMap();
        }
        if (classMapper.getColumnWithJavaName(columnName).getField().getType().isPrimitive()) {
            this.visitPrimitive(codeBuilder, progressive, var, classMapper, columnName);
        } else {
            this.visitObject(codeBuilder, progressive, var, classMapper, columnName);
        }
    }

    protected final void visitPrimitive(CodeBuilder codeBuilder, int progressive, LocalVariable var, IClassMapper<?> classMapper, String columnName) {
        this.logger.debug("visitPrimitive", "visit primitive getter method for [" + columnName + "]");
        this.logger.debug("visitPrimitive", "getter method type: " + classMapper.getColumnWithJavaName(columnName).getField().getType().getName());
        codeBuilder.dup();
        codeBuilder.loadConstant(progressive);
        codeBuilder.loadLocal(var);
        String className = classMapper.getMappedClass().getName();
        Method method = classMapper.getColumnWithJavaName(columnName).getGetter();
        Field field = classMapper.getColumnWithJavaName(columnName).getField();
        Class<?> wrapperClass = primitiveClassMap.get(field.getType());
        this.logger.debug("visitPrimitive", "Using wrapper class of type: " + wrapperClass.getName());
        codeBuilder.invokeVirtual(className, method.getName(), TypeDesc.forClass(field.getType()), null);
        TypeDesc type_2 = TypeDesc.forClass(wrapperClass);
        TypeDesc[] params_1 = new TypeDesc[]{TypeDesc.forClass(field.getType())};
        codeBuilder.invokeStatic(wrapperClass.getName(), "valueOf", type_2, params_1);
        codeBuilder.storeToArray(TypeDesc.OBJECT);
    }

    protected final void visitObject(CodeBuilder codeBuilder, int progressive, LocalVariable var, IClassMapper<?> classMapper, String columnName) {
        this.logger.debug("visitObject", "visit object getter method for [" + columnName + "]");
        this.logger.debug("visitPrimitive", "getter method type: " + classMapper.getColumnWithJavaName(columnName).getField().getType().getName());
        String className = classMapper.getMappedClass().getName();
        Method method = classMapper.getColumnWithJavaName(columnName).getGetter();
        Field field = classMapper.getColumnWithJavaName(columnName).getField();
        codeBuilder.dup();
        codeBuilder.loadConstant(progressive);
        codeBuilder.loadLocal(var);
        codeBuilder.invokeVirtual(className, method.getName(), TypeDesc.forClass(field.getType()), null);
        codeBuilder.storeToArray(TypeDesc.OBJECT);
    }

    private void initPrimitiveClassMap() {
        primitiveClassMap = new HashMap();
        primitiveClassMap.put(Boolean.TYPE, Boolean.class);
        primitiveClassMap.put(Byte.TYPE, Byte.class);
        primitiveClassMap.put(Character.TYPE, Character.class);
        primitiveClassMap.put(Double.TYPE, Double.class);
        primitiveClassMap.put(Float.TYPE, Float.class);
        primitiveClassMap.put(Integer.TYPE, Integer.class);
        primitiveClassMap.put(Long.TYPE, Long.class);
        primitiveClassMap.put(Short.TYPE, Short.class);
    }
}

