/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.jdbctemplate;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ITransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class JdbcTemplateTransaction
implements ITransaction {
    private final TransactionStatus transactionStatus;
    private final PlatformTransactionManager platformTransactionManager;

    public JdbcTemplateTransaction(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        this.transactionStatus = platformTransactionManager.getTransaction((TransactionDefinition)definition);
    }

    @Override
    public void setRollbackOnly() throws OrmException {
        try {
            this.transactionStatus.setRollbackOnly();
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void commit() throws OrmException {
        try {
            this.platformTransactionManager.commit(this.transactionStatus);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void rollback() throws OrmException {
        try {
            this.platformTransactionManager.rollback(this.transactionStatus);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }
}

