/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.sql;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.query.AQuery;
import com.jpattern.orm.query.ISqlQuery;
import com.jpattern.orm.session.IResultSetReader;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;
import java.math.BigDecimal;
import java.util.List;

public class SqlQuery
extends AQuery
implements ISqlQuery {
    private final ISessionSqlPerformer session;
    private final String sql;
    private final Object[] args;
    private int queryTimeout = 0;
    private int maxRows = 0;

    public SqlQuery(ISessionSqlPerformer session, String sql, Object[] args) {
        this.session = session;
        this.sql = sql;
        this.args = args;
    }

    @Override
    public final int getMaxRows() throws OrmException {
        return this.maxRows;
    }

    @Override
    public final ISqlQuery setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public final int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public final ISqlQuery setMaxRows(int maxRows) throws OrmException {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public <T> T find(IResultSetReader<T> rse) throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.query(this.renderSql(), rse, this.args);
    }

    @Override
    public List<Object[]> findList() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForList(this.renderSql(), this.args);
    }

    @Override
    public Object[] findUnique() throws OrmNotUniqueResultException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForArray(this.renderSql(), this.args);
    }

    @Override
    public int findInt() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForInt(this.renderSql(), this.args);
    }

    @Override
    public long findLong() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForLong(this.renderSql(), this.args);
    }

    @Override
    public double findDouble() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForDouble(this.renderSql(), this.args);
    }

    @Override
    public float findFloat() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForFloat(this.renderSql(), this.args).floatValue();
    }

    @Override
    public String findString() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForString(this.renderSql(), this.args);
    }

    @Override
    public boolean findBoolean() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBoolean(this.renderSql(), this.args);
    }

    @Override
    public BigDecimal findBigDecimal() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBigDecimal(this.renderSql(), this.args);
    }

    @Override
    public void appendValues(List<Object> values) {
        for (Object object : this.args) {
            values.add(object);
        }
    }

    @Override
    public String renderSql() {
        return this.sql;
    }

    @Override
    public void renderSql(StringBuilder StringBuilder2) {
        StringBuilder2.append(this.sql);
    }
}

