/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ASession;
import com.jpattern.orm.session.ISqlPerformer;
import com.jpattern.orm.session.ITransaction;
import com.jpattern.orm.session.datasource.DataSourceSqlPerformer;
import com.jpattern.orm.session.datasource.DataSourceTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceSession
extends ASession {
    private final Connection conn;

    public DataSourceSession(DataSource dataSource, IOrmClassToolMap ormClassToolMap) {
        super(ormClassToolMap);
        try {
            this.conn = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public ITransaction beginTransaction() throws OrmException {
        return new DataSourceTransaction(this.conn);
    }

    @Override
    public void close() throws OrmException {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public ISqlPerformer sqlPerformer() throws OrmException {
        return new DataSourceSqlPerformer(this.conn);
    }
}

