/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class OrmUtil {
    public static String UTF8 = "UTF-8";

    public static Reader convertStringToReader(String text) throws IOException {
        return new StringReader(text);
    }

    public static String convertReaderToString(Reader reader, boolean closeReader) throws IOException {
        if (reader != null) {
            int n;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            ((Writer)writer).close();
            if (closeReader) {
                reader.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static InputStream convertStringToStream(String text, String encoding) throws IOException {
        return new ByteArrayInputStream(text.getBytes(encoding));
    }

    public static String convertStreamToString(InputStream is, String encoding, boolean closeStream) throws IOException {
        InputStreamReader isr = new InputStreamReader(is, encoding);
        BufferedReader reader = new BufferedReader(isr);
        String result = OrmUtil.convertReaderToString(reader, true);
        isr.close();
        if (closeStream) {
            is.close();
        }
        return result;
    }
}

