/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query;

import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.IOrderBy;
import com.jpattern.orm.query.IOrderElement;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.order.OrderByType;
import com.jpattern.orm.query.order.OrderElement;
import java.util.ArrayList;
import java.util.List;

public class OrderBy
implements IOrderBy {
    private INameSolver nameSolver = new NullNameSolver();
    private List<IOrderElement> elementList = new ArrayList<IOrderElement>();

    @Override
    public IOrderBy asc(String property) {
        this.elementList.add(new OrderElement(this.nameSolver, property, this.elementList.isEmpty(), OrderByType.ASC));
        return this;
    }

    @Override
    public IOrderBy desc(String property) {
        this.elementList.add(new OrderElement(this.nameSolver, property, this.elementList.isEmpty(), OrderByType.DESC));
        return this;
    }

    @Override
    public String renderSql() {
        StringBuilder query = new StringBuilder();
        this.renderSql(query);
        return query.toString();
    }

    @Override
    public void renderSql(StringBuilder StringBuilder2) {
        if (!this.elementList.isEmpty()) {
            StringBuilder2.append("ORDER BY ");
            for (IOrderElement expressionElement : this.elementList) {
                expressionElement.renderSql(StringBuilder2);
            }
        }
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }
}

