/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.generator;

import com.jpattern.logger.ILogger;
import com.jpattern.org.cojen.classfile.CodeBuilder;
import com.jpattern.org.cojen.classfile.LocalVariable;
import com.jpattern.org.cojen.classfile.TypeDesc;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.generator.MethodHelper;
import com.jpattern.orm.logger.OrmLogger;
import com.jpattern.orm.mapper.IClassMapper;
import com.jpattern.orm.mapper.IColumn;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;

public class SetterDumpFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ILogger logger = OrmLogger.getOrmLogger(this.getClass());

    public void visit(CodeBuilder codeBuilder, LocalVariable rowNamePrefix, IClassMapper<?> classMapper, String columnName) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        IColumn column = classMapper.getColumnWithJavaName(columnName);
        this.logger.debug("visit", "visit setter method for [" + columnName + "]");
        this.logger.debug("visit", "setter method type: " + column.getField().getType().getName());
        Field field = column.getField();
        Method resultSetMethod = MethodHelper.findResultSetGetterForString(field.getType());
        this.logger.debug("visit", "Using " + ResultSet.class.getName() + " method: " + resultSetMethod.getName());
        TypeDesc stringBuilder = TypeDesc.forClass((String)StringBuilder.class.getName());
        codeBuilder.newObject(stringBuilder);
        codeBuilder.dup();
        codeBuilder.loadLocal(rowNamePrefix);
        TypeDesc[] params_0 = new TypeDesc[]{TypeDesc.OBJECT};
        codeBuilder.invokeStatic(String.class.getName(), "valueOf", TypeDesc.STRING, params_0);
        TypeDesc[] params_1 = new TypeDesc[]{TypeDesc.STRING};
        codeBuilder.invokeConstructor(StringBuilder.class.getName(), params_1);
        codeBuilder.loadConstant(classMapper.getColumnWithJavaName(columnName).getName());
        codeBuilder.invokeVirtual(StringBuilder.class.getName(), "append", stringBuilder, params_1);
        codeBuilder.invokeVirtual(StringBuilder.class.getName(), "toString", TypeDesc.STRING, null);
        codeBuilder.invokeInterface(ResultSet.class.getName(), resultSetMethod.getName(), TypeDesc.forClass(field.getType()), params_1);
        TypeDesc[] params_2 = new TypeDesc[]{TypeDesc.forClass(field.getType())};
        codeBuilder.invokeVirtual(classMapper.getMappedClass().getName(), column.getSetter().getName(), null, params_2);
    }

    public void visit(CodeBuilder codeBuilder, IClassMapper<?> classMapper, String columnName, int columnIndex) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        IColumn column = classMapper.getColumnWithJavaName(columnName);
        this.logger.debug("visit", "visit setter method for [" + columnName + "]");
        this.logger.debug("visit", "setter method type: " + column.getField().getType().getName());
        Field field = column.getField();
        Method resultSetMethod = MethodHelper.findResultSetGetterForInt(field.getType());
        this.logger.debug("visit", "Using " + ResultSet.class.getName() + " method: " + resultSetMethod.getName());
        codeBuilder.loadConstant(columnIndex);
        TypeDesc[] params_1 = new TypeDesc[]{TypeDesc.INT};
        codeBuilder.invokeInterface(ResultSet.class.getName(), resultSetMethod.getName(), TypeDesc.forClass(field.getType()), params_1);
        TypeDesc[] params_2 = new TypeDesc[]{TypeDesc.forClass(field.getType())};
        codeBuilder.invokeVirtual(classMapper.getMappedClass().getName(), column.getSetter().getName(), null, params_2);
    }
}

