/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.mapper;

import com.jpattern.orm.crud.AColumnValueGenerator;
import com.jpattern.orm.crud.NullColumnValueGenerator;
import com.jpattern.orm.mapper.ITableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableMap
implements ITableMap {
    private static final long serialVersionUID = 1L;
    private List<String> primaryKeyFieldList = new ArrayList<String>();
    private Map<String, String> columnNamesMap = new HashMap<String, String>();
    private Map<String, String> javaFieldNamesMap = new HashMap<String, String>();
    private Map<String, AColumnValueGenerator> generatorByColumnName = new HashMap<String, AColumnValueGenerator>();
    private Map<String, AColumnValueGenerator> generatorByJavaFieldName = new HashMap<String, AColumnValueGenerator>();
    private String schemaName;
    private String tableName;

    @Override
    public String getSchemaName() {
        if (this.schemaName == null) {
            this.schemaName = "";
        }
        return this.schemaName;
    }

    @Override
    public String getTableName() {
        if (this.tableName == null) {
            this.tableName = "";
        }
        return this.tableName;
    }

    @Override
    public String getTableNameWithSchema() {
        String schema = this.getSchemaName();
        if (schema.length() == 0) {
            return this.getTableName();
        }
        return schema + "." + this.getTableName();
    }

    public void addColumnMapping(String javaFieldName, String columnName, AColumnValueGenerator columnValueGenerator) {
        if (javaFieldName != null && columnName != null) {
            this.columnNamesMap.put(javaFieldName, columnName);
            this.javaFieldNamesMap.put(columnName, javaFieldName);
            this.generatorByColumnName.put(columnName, columnValueGenerator);
            this.generatorByJavaFieldName.put(javaFieldName, columnValueGenerator);
        }
    }

    @Override
    public String getDBColumnName(String javaFieldName) {
        if (this.columnNamesMap.containsKey(javaFieldName)) {
            return this.columnNamesMap.get(javaFieldName);
        }
        return "";
    }

    @Override
    public String getJavaFieldName(String dbColumnName) {
        if (this.javaFieldNamesMap.containsKey(dbColumnName)) {
            return this.javaFieldNamesMap.get(dbColumnName);
        }
        return "";
    }

    @Override
    public List<String> getPrimaryKeyFieldNames() {
        return this.primaryKeyFieldList;
    }

    public void addPrimaryKey(String primaryKeyField) {
        this.primaryKeyFieldList.add(primaryKeyField);
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public List<String> getAllFieldNames() {
        return new ArrayList<String>(this.columnNamesMap.keySet());
    }

    @Override
    public AColumnValueGenerator getGeneratorByColumnName(String columnName) {
        if (this.generatorByColumnName.containsKey(columnName)) {
            return this.generatorByColumnName.get(columnName);
        }
        return new NullColumnValueGenerator("");
    }

    @Override
    public AColumnValueGenerator getGeneratorByJavaFieldName(String javaFieldName) {
        if (this.generatorByJavaFieldName.containsKey(javaFieldName)) {
            return this.generatorByJavaFieldName.get(javaFieldName);
        }
        return new NullColumnValueGenerator("");
    }
}

