/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.mapper.IClassMapper;
import com.jpattern.orm.query.INameSolver;
import java.util.LinkedHashMap;
import java.util.Map;

public class OrmClassToolMapNameSolver
implements INameSolver {
    private static final long serialVersionUID = 1L;
    private Map<String, IClassMapper<?>> registeredClass = new LinkedHashMap();
    private Map<Class<?>, String> classAlias = new LinkedHashMap();
    private final IOrmClassToolMap ormClassToolMap;
    private boolean resolveWithoutAlias = false;

    public OrmClassToolMapNameSolver(IOrmClassToolMap ormClassToolMap) {
        this.ormClassToolMap = ormClassToolMap;
    }

    @Override
    public String solvePropertyName(String property) throws OrmException {
        if (this.resolveWithoutAlias) {
            return this.solvePropertyNameWithoutAlias(property);
        }
        String alias = this.alias(property);
        String field = this.field(property);
        if (!this.registeredClass.containsKey(alias)) {
            throw new OrmException("Alias [" + alias + "] is not associated with an Orm Entity. Registered alias are: " + this.registeredClass.keySet());
        }
        String dbColumn = this.registeredClass.get(alias).getColumnWithJavaName(field).getName();
        return alias + "." + dbColumn;
    }

    @Override
    public String solvePropertyName(String property, String defaultValue) throws OrmException {
        String alias = this.alias(property);
        String field = this.field(property);
        if (!this.registeredClass.containsKey(alias)) {
            return defaultValue;
        }
        String dbColumn = this.registeredClass.get(alias).getColumnWithJavaName(field).getName();
        return alias + "." + dbColumn;
    }

    @Override
    public void register(Class<?> clazz) throws OrmException {
        this.register(clazz, clazz.getSimpleName());
    }

    @Override
    public void register(Class<?> clazz, String alias) throws OrmException {
        this.registeredClass.put(alias, this.ormClassToolMap.getOrmClassTool(clazz).getClassMapper());
        this.classAlias.put(clazz, alias);
    }

    @Override
    public String alias(Class<?> clazz) throws OrmException {
        if (!this.classAlias.containsKey(clazz)) {
            throw new OrmException("Class " + clazz + " is not in the query");
        }
        return this.classAlias.get(clazz);
    }

    private String alias(String property) throws OrmException {
        try {
            return property.substring(0, property.lastIndexOf("."));
        }
        catch (Exception e) {
            throw new OrmException("Error parsing property [" + property + "], the format must be CLASS_NAME.CLASS_FIELD or CLASS_ALIAS.CLASS_FIELD");
        }
    }

    private String field(String property) throws OrmException {
        try {
            return property.substring(property.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            throw new OrmException("Error parsing property [" + property + "], the format must be CLASS_NAME.CLASS_FIELD or CLASS_ALIAS.CLASS_FIELD");
        }
    }

    @Override
    public String solvePropertyNameWithoutAlias(String property) throws OrmException {
        String alias = this.alias(property);
        String field = this.field(property);
        if (!this.registeredClass.containsKey(alias)) {
            throw new OrmException("Alias [" + alias + "] is not associated with an Orm Entity. Registered alias are: " + this.registeredClass.keySet());
        }
        return this.registeredClass.get(alias).getColumnWithJavaName(field).getName();
    }

    @Override
    public void alwaysResolveWithoutAlias(boolean resolveWithoutAlias) {
        this.resolveWithoutAlias = resolveWithoutAlias;
    }

    @Override
    public boolean getAlwaysResolveWithoutAlias() {
        return this.resolveWithoutAlias;
    }
}

