/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.join;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.join.IJoinElement;

public abstract class AJoinElement
implements IJoinElement {
    private static final long serialVersionUID = 1L;
    protected final Class<?> joinClass;
    private INameSolver nameSolver;
    protected final IOrmClassToolMap ormClassToolMap;

    public AJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass) {
        this.ormClassToolMap = ormClassToolMap;
        this.joinClass = joinClass;
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public String renderSql() {
        StringBuilder query = new StringBuilder();
        this.renderSql(query);
        return query.toString();
    }

    @Override
    public void renderSql(StringBuilder StringBuilder2) {
        String alias = this.nameSolver.alias(this.joinClass);
        StringBuilder2.append(this.getJoinName());
        StringBuilder2.append(this.ormClassToolMap.getOrmClassTool(this.joinClass).getClassMapper().getTableMap().getTableNameWithSchema());
        StringBuilder2.append(" ");
        StringBuilder2.append(alias);
        if (this.hasOnClause()) {
            StringBuilder2.append(" ON ");
            StringBuilder2.append(this.nameSolver.solvePropertyName(this.onLeftProperty()));
            StringBuilder2.append(" = ");
            StringBuilder2.append(this.nameSolver.solvePropertyName(this.onRightProperty()));
        }
        StringBuilder2.append(" ");
    }

    protected abstract String getJoinName();

    protected abstract boolean hasOnClause();

    protected abstract String onLeftProperty();

    protected abstract String onRightProperty();
}

