/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.sql;

import com.jpattern.orm.query.ISqlBatchUpdate;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;
import java.util.List;

public class SqlBatchUpdate
implements ISqlBatchUpdate {
    private static final long serialVersionUID = 1L;
    private int queryTimeout = 0;
    private final ISessionSqlPerformer session;
    private final String sql;
    private final List<Object[]> args;

    public SqlBatchUpdate(ISessionSqlPerformer session, String sql, List<Object[]> args) {
        this.session = session;
        this.sql = sql;
        this.args = args;
    }

    @Override
    public void execute() {
        this.update();
    }

    @Override
    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public int[] update() {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.batchUpdate(this.sql, this.args);
    }
}

