/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.script;

import com.jpattern.orm.script.IParser;
import com.jpattern.orm.script.IParserCallback;
import com.jpattern.orm.util.GenericWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class StreamParser
implements IParser {
    private static final long serialVersionUID = 1L;
    private final InputStream inputStream;
    private final Charset charset;
    private final boolean closeInputStream;

    public StreamParser(InputStream inputStream, boolean closeInputStream) {
        this(inputStream, closeInputStream, Charset.defaultCharset());
    }

    public StreamParser(InputStream inputStream, boolean closeInputStream, Charset charset) {
        this.inputStream = inputStream;
        this.closeInputStream = closeInputStream;
        this.charset = charset;
    }

    @Override
    public void parse(IParserCallback parserCallback) throws IOException {
        this.parse(parserCallback, ";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(IParserCallback parserCallback, String spearatorSymbol) throws IOException {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(this.inputStream, this.charset);
            bufferedReader = new BufferedReader(inputStreamReader);
            this.findStatement(parserCallback, bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (this.closeInputStream && this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }

    private boolean findStatement(IParserCallback parserCallback, BufferedReader bufferedReader) throws IOException {
        StringBuilder StringBuilder2 = new StringBuilder();
        String line = null;
        GenericWrapper<Integer> apostrophes = new GenericWrapper<Integer>(0);
        while ((line = bufferedReader.readLine()) != null) {
            this.checkend(parserCallback, StringBuilder2, line, apostrophes);
        }
        return false;
    }

    private void checkend(IParserCallback parserCallback, StringBuilder StringBuilder2, String line, GenericWrapper<Integer> apostrophesWrapper) {
        String trimmedline = line.trim();
        if (!trimmedline.isEmpty() && !trimmedline.startsWith("--")) {
            if (line.contains(";")) {
                String[] splitted = line.split(";");
                int position = 0;
                for (int i = 0; i < splitted.length; ++i) {
                    int apostrophes = apostrophesWrapper.getValue();
                    String token = splitted[i];
                    position += token.length() + 1;
                    apostrophesWrapper.setValue(apostrophes += this.countApostrophes(token));
                    if (apostrophes % 2 != 1) {
                        StringBuilder2.append(token);
                        parserCallback.parseAction(StringBuilder2.toString());
                        StringBuilder2.setLength(0);
                        apostrophesWrapper.setValue(0);
                        line = line.substring(position, line.length());
                        this.checkend(parserCallback, StringBuilder2, line, apostrophesWrapper);
                        break;
                    }
                    StringBuilder2.append(token + ";");
                }
            } else {
                StringBuilder2.append(line + "\n");
            }
        }
    }

    private int countApostrophes(String line) {
        int count = 0;
        int index = 0;
        while ((index = line.indexOf("'", index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }
}

