/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ITransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class DataSourceTransaction
implements ITransaction {
    private static final long serialVersionUID = 1L;
    private final Connection conn;
    private boolean rollbackOnly = false;
    private Savepoint savepoint;

    public DataSourceTransaction(Connection conn, int transactionIsolation) {
        this.conn = conn;
        try {
            conn.setTransactionIsolation(transactionIsolation);
            this.savepoint = this.conn.setSavepoint();
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void setRollbackOnly() throws OrmException {
        this.rollbackOnly = true;
    }

    @Override
    public void rollback() throws OrmException {
        try {
            this.conn.rollback(this.savepoint);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void commit() throws OrmException {
        if (this.rollbackOnly) {
            this.rollback();
            return;
        }
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }
}

