/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.jdbctemplate;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ASqlPerformer;
import com.jpattern.orm.session.IGeneratedKeyReader;
import com.jpattern.orm.session.IPreparedStatementCreator;
import com.jpattern.orm.session.IResultSetReader;
import com.jpattern.orm.session.jdbctemplate.GeneratorKeyResultSet;
import com.jpattern.orm.session.jdbctemplate.ResultSetReaderWrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcTemplateSqlPerformer
extends ASqlPerformer {
    private static final long serialVersionUID = 1L;
    private final JdbcTemplate jdbcTemplate;
    private int maxRows = 0;
    private int queryTimeout = 0;

    public JdbcTemplateSqlPerformer(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void execute(String sql) throws OrmException {
        int oldMaxRows = this.jdbcTemplate.getMaxRows();
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            this.jdbcTemplate.setMaxRows(this.getMaxRows());
            this.jdbcTemplate.setQueryTimeout(this.getQueryTimeout());
            this.jdbcTemplate.execute(sql);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            this.jdbcTemplate.setMaxRows(oldMaxRows);
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    @Override
    public <T> T query(String sql, IResultSetReader<T> rse, Object ... args) throws OrmException {
        int oldMaxRows = this.jdbcTemplate.getMaxRows();
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            this.jdbcTemplate.setMaxRows(this.getMaxRows());
            this.jdbcTemplate.setQueryTimeout(this.getQueryTimeout());
            Object object = this.jdbcTemplate.query(sql, args, new ResultSetReaderWrapper<T>(rse));
            return (T)object;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            this.jdbcTemplate.setMaxRows(oldMaxRows);
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    @Override
    public int update(String sql, Object ... args) throws OrmException {
        try {
            return this.jdbcTemplate.update(sql, args);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public int update(final String sql, final IGeneratedKeyReader generatedKeyReader, final Object ... args) throws OrmException {
        try {
            PreparedStatementCreator psc = new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = null;
                    ps = con.prepareStatement(sql, generatedKeyReader.generatedColumnNames());
                    int i = 0;
                    for (Object value : args) {
                        ps.setObject(++i, value);
                    }
                    return ps;
                }
            };
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            int result = this.jdbcTemplate.update(psc, (KeyHolder)keyHolder);
            generatedKeyReader.read(new GeneratorKeyResultSet((KeyHolder)keyHolder));
            return result;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public int[] batchUpdate(List<String> sqls) throws OrmException {
        try {
            return this.jdbcTemplate.batchUpdate(sqls.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public int[] batchUpdate(String sql, final List<Object[]> args) throws OrmException {
        try {
            BatchPreparedStatementSetter bpss = new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    int count = 0;
                    for (Object object : (Object[])args.get(i)) {
                        ps.setObject(++count, object);
                    }
                }

                public int getBatchSize() {
                    return args.size();
                }
            };
            return this.jdbcTemplate.batchUpdate(sql, bpss);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public int[] batchUpdate(String sql, final IPreparedStatementCreator psc) throws OrmException {
        try {
            BatchPreparedStatementSetter bpss = new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    psc.set(ps, i);
                }

                public int getBatchSize() {
                    return psc.getBatchSize();
                }
            };
            return this.jdbcTemplate.batchUpdate(sql, bpss);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }
}

