/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query;

import com.jpattern.orm.query.IExpression;
import com.jpattern.orm.query.IExpressionElement;
import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.IQuery;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.expression.AndExpressionElement;
import com.jpattern.orm.query.expression.EqExpressionElement;
import com.jpattern.orm.query.expression.EqPropertiesExpressionElement;
import com.jpattern.orm.query.expression.GeExpressionElement;
import com.jpattern.orm.query.expression.GePropertiesExpressionElement;
import com.jpattern.orm.query.expression.GtExpressionElement;
import com.jpattern.orm.query.expression.GtPropertiesExpressionElement;
import com.jpattern.orm.query.expression.IEqExpressionElement;
import com.jpattern.orm.query.expression.IEqPropertiesExpressionElement;
import com.jpattern.orm.query.expression.ILikeExpressionElement;
import com.jpattern.orm.query.expression.InExpressionElement;
import com.jpattern.orm.query.expression.InSubQueryExpressionElement;
import com.jpattern.orm.query.expression.IsNotNullExpressionElement;
import com.jpattern.orm.query.expression.IsNullExpressionElement;
import com.jpattern.orm.query.expression.LeExpressionElement;
import com.jpattern.orm.query.expression.LePropertiesExpressionElement;
import com.jpattern.orm.query.expression.LikeExpressionElement;
import com.jpattern.orm.query.expression.LtExpressionElement;
import com.jpattern.orm.query.expression.LtPropertiesExpressionElement;
import com.jpattern.orm.query.expression.NInExpressionElement;
import com.jpattern.orm.query.expression.NLikeExpressionElement;
import com.jpattern.orm.query.expression.NeExpressionElement;
import com.jpattern.orm.query.expression.NePropertiesExpressionElement;
import com.jpattern.orm.query.expression.NotExpressionElement;
import com.jpattern.orm.query.expression.OrExpressionElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Expression
implements IExpression {
    List<IExpressionElement> elementList = new ArrayList<IExpressionElement>();
    private INameSolver nameSolver = new NullNameSolver();

    @Override
    public IExpression allEq(Map<String, Object> propertyMap) {
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            this.eq(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public IExpression eq(String property, Object value) {
        EqExpressionElement expressionElement = new EqExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression eqProperties(String firstProperty, String secondProperty) {
        EqPropertiesExpressionElement expressionElement = new EqPropertiesExpressionElement(firstProperty, secondProperty);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression le(String property, Object value) {
        LeExpressionElement expressionElement = new LeExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression leProperties(String firstProperty, String secondProperty) {
        LePropertiesExpressionElement expressionElement = new LePropertiesExpressionElement(firstProperty, secondProperty);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression ge(String property, Object value) {
        GeExpressionElement expressionElement = new GeExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression geProperties(String firstProperty, String secondProperty) {
        GePropertiesExpressionElement expressionElement = new GePropertiesExpressionElement(firstProperty, secondProperty);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression lt(String property, Object value) {
        LtExpressionElement expressionElement = new LtExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression ltProperties(String firstProperty, String secondProperty) {
        LtPropertiesExpressionElement expressionElement = new LtPropertiesExpressionElement(firstProperty, secondProperty);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression gt(String property, Object value) {
        GtExpressionElement expressionElement = new GtExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression gtProperties(String firstProperty, String secondProperty) {
        GtPropertiesExpressionElement expressionElement = new GtPropertiesExpressionElement(firstProperty, secondProperty);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression ieq(String property, String value) {
        IEqExpressionElement expressionElement = new IEqExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression ieqProperties(String firstProperty, String secondProperty) {
        IEqPropertiesExpressionElement expressionElement = new IEqPropertiesExpressionElement(firstProperty, secondProperty);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression ilike(String property, String value) {
        ILikeExpressionElement expressionElement = new ILikeExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression in(String property, Collection<?> values) {
        InExpressionElement expressionElement = new InExpressionElement(property, values);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression in(String property, Object[] values) {
        return this.in(property, Arrays.asList(values));
    }

    @Override
    public IExpression in(String property, IQuery subQuery) {
        InSubQueryExpressionElement expressionElement = new InSubQueryExpressionElement(property, subQuery, true);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression nin(String property, Collection<?> values) {
        NInExpressionElement expressionElement = new NInExpressionElement(property, values);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression nin(String property, Object[] values) {
        return this.nin(property, Arrays.asList(values));
    }

    @Override
    public IExpression nin(String property, IQuery subQuery) {
        InSubQueryExpressionElement expressionElement = new InSubQueryExpressionElement(property, subQuery, false);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression isNotNull(String property) {
        IsNotNullExpressionElement expressionElement = new IsNotNullExpressionElement(property);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression isNull(String property) {
        IsNullExpressionElement expressionElement = new IsNullExpressionElement(property);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression like(String property, String value) {
        LikeExpressionElement expressionElement = new LikeExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression nlike(String property, String value) {
        NLikeExpressionElement expressionElement = new NLikeExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression ne(String property, Object value) {
        NeExpressionElement expressionElement = new NeExpressionElement(property, value);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression neProperties(String firstProperty, String secondProperty) {
        NePropertiesExpressionElement expressionElement = new NePropertiesExpressionElement(firstProperty, secondProperty);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression not(IExpressionElement expression) {
        NotExpressionElement expressionElement = new NotExpressionElement(expression);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression or(IExpressionElement expressionOne, IExpressionElement expressionTwo) {
        OrExpressionElement expressionElement = new OrExpressionElement(expressionOne, expressionTwo);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public IExpression and(IExpressionElement expressionOne, IExpressionElement expressionTwo) {
        AndExpressionElement expressionElement = new AndExpressionElement(expressionOne, expressionTwo);
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this;
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public String renderSql() {
        StringBuilder StringBuilder2 = new StringBuilder();
        this.renderSql(StringBuilder2);
        return StringBuilder2.toString();
    }

    @Override
    public void renderSql(StringBuilder StringBuilder2) {
        boolean first = true;
        if (!this.elementList.isEmpty()) {
            StringBuilder2.append("WHERE ");
            for (IExpressionElement expressionElement : this.elementList) {
                if (!first) {
                    StringBuilder2.append("AND ");
                }
                expressionElement.renderSql(StringBuilder2);
                first = false;
            }
        }
    }

    @Override
    public void appendValues(List<Object> values) {
        if (!this.elementList.isEmpty()) {
            for (IExpressionElement expressionElement : this.elementList) {
                expressionElement.appendValues(values);
            }
        }
    }
}

