/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm;

import com.jpattern.logger.ILogger;
import com.jpattern.orm.IJPOrmBase;
import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.IOrmPersistor;
import com.jpattern.orm.OrmClassTool;
import com.jpattern.orm.OrmClassToolMap;
import com.jpattern.orm.crud.IOrmCRUDQuery;
import com.jpattern.orm.crud.OrmCRUDQueryGenerator;
import com.jpattern.orm.dialect.IDialect;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.generator.CojenPersistorGenerator;
import com.jpattern.orm.logger.OrmLogger;
import com.jpattern.orm.mapper.ClassMapperBuilder;
import com.jpattern.orm.mapper.ClassTableMapBuilder;
import com.jpattern.orm.mapper.IClassMapper;
import com.jpattern.orm.mapper.TableMap;
import com.jpattern.orm.session.ISession;
import com.jpattern.orm.session.ISessionProvider;

public abstract class AJPOrmBase
implements IJPOrmBase {
    private final ISessionProvider sessionProvider;
    private IOrmClassToolMap ormClassToolMap = new OrmClassToolMap();
    private ILogger logger = OrmLogger.getOrmLogger(this.getClass());
    private final IDialect dialect;

    public AJPOrmBase(ISessionProvider sessionProvider, IDialect dialect) {
        this.sessionProvider = sessionProvider;
        this.dialect = dialect;
    }

    protected ISession getSession() {
        return this.sessionProvider.getSession(this.ormClassToolMap);
    }

    @Override
    public <T> void register(Class<T> clazz) throws OrmConfigurationException {
        this.register(clazz, true);
    }

    @Override
    public <T> void register(Class<T> clazz, boolean enableDBScan) throws OrmConfigurationException {
        this.logger.info("register", "register new class: " + clazz.getName());
        try {
            TableMap tableMap = new TableMap();
            new ClassTableMapBuilder(clazz, tableMap).updateTableMap();
            this.sessionProvider.updateTableMap(tableMap, enableDBScan);
            IClassMapper<T> classMapper = new ClassMapperBuilder<T>(clazz, tableMap).generate();
            IOrmPersistor<T> ormPersistor = new CojenPersistorGenerator<T>(classMapper).generate();
            IOrmCRUDQuery ormCRUDQuery = new OrmCRUDQueryGenerator<T>(this.dialect, classMapper).generate();
            OrmClassTool<T> ormClassTool = new OrmClassTool<T>(classMapper, ormPersistor, ormCRUDQuery);
            this.ormClassToolMap.put(clazz, ormClassTool);
        }
        catch (Exception e) {
            throw new OrmConfigurationException(e);
        }
    }
}

