/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query;

import com.jpattern.orm.IOrmClassTool;
import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.query.ABaseOrmQuery;
import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.INameSolverConsumer;
import com.jpattern.orm.query.IOrmQuery;
import com.jpattern.orm.query.IOrmSerialResultReader;
import com.jpattern.orm.query.Join;
import com.jpattern.orm.query.LockMode;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.session.IResultSetReader;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OrmQuery<T>
extends ABaseOrmQuery
implements IOrmQuery<T>,
INameSolverConsumer {
    private INameSolver nameSolver = new NullNameSolver();
    private final IOrmClassToolMap ormClassToolMap;
    private final Class<T> clazz;
    private final Class<?>[] joinClasses;
    private boolean distinct;
    private final ISessionSqlPerformer session;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private LockMode lockMode = LockMode.NO_LOCK;

    public OrmQuery(IOrmClassToolMap ormClassToolMap, ISessionSqlPerformer session, Class<T> clazz, Class<?> ... joinClasses) {
        this.ormClassToolMap = ormClassToolMap;
        this.session = session;
        this.clazz = clazz;
        this.joinClasses = joinClasses;
        this.setJoin(new Join(ormClassToolMap));
    }

    @Override
    public final int getMaxRows() throws OrmException {
        return this.maxRows;
    }

    @Override
    public final IOrmQuery<T> setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public final int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public final IOrmQuery<T> setMaxRows(int maxRows) throws OrmException {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
        this.where().setNameSolver(nameSolver);
        this.orderBy().setNameSolver(nameSolver);
        this.join().setNameSolver(nameSolver);
    }

    @Override
    public List<T> findList() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        final IOrmClassTool<T> ormClassTool = this.ormClassToolMap.getOrmClassTool(this.clazz);
        IResultSetReader resultSetReader = new IResultSetReader<List<T>>(){

            @Override
            public List<T> read(ResultSet resultSet) throws SQLException {
                ArrayList resultList = new ArrayList();
                int rowCount = 0;
                while (resultSet.next()) {
                    resultList.add(ormClassTool.getOrmPersistor().mapRow("", resultSet, rowCount++));
                }
                return resultList;
            }
        };
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return (List)sqlExec.query(this.renderSql(), resultSetReader, values.toArray());
    }

    @Override
    public void find(final IOrmSerialResultReader<T> srr) throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        final IOrmClassTool<T> ormClassTool = this.ormClassToolMap.getOrmClassTool(this.clazz);
        IResultSetReader<Object> resultSetReader = new IResultSetReader<Object>(){

            @Override
            public Object read(ResultSet resultSet) throws SQLException {
                int rowCount = 0;
                while (resultSet.next()) {
                    srr.read(ormClassTool.getOrmPersistor().mapRow("", resultSet, rowCount), rowCount);
                    ++rowCount;
                }
                return null;
            }
        };
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        sqlExec.query(this.renderSql(), resultSetReader, values.toArray());
    }

    @Override
    public long findRowCount() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForLong(this.getGeneratedRowCountSql(), values.toArray());
    }

    @Override
    public T findUnique() throws OrmNotUniqueResultException {
        int oldMaxRow = this.getMaxRows();
        this.setMaxRows(2);
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        List<T> result = this.findList();
        this.setMaxRows(oldMaxRow);
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
        }
        return result.get(0);
    }

    @Override
    public String getGeneratedRowCountSql() {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderSelectRowCount(stringBuilder);
        this.renderFrom(stringBuilder);
        this.renderWhere(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public IOrmQuery<T> setDistinct() {
        this.distinct = true;
        return this;
    }

    private void renderSelectRowCount(StringBuilder stringBuilder) {
        stringBuilder.append("SELECT COUNT(*) ");
    }

    @Override
    protected void renderSelect(StringBuilder stringBuilder) {
        String alias = this.nameSolver.alias(this.clazz);
        stringBuilder.append("SELECT ");
        if (this.distinct) {
            stringBuilder.append("DISTINCT ");
        }
        stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getOrmCRUDQuery().getBaseSelectClause(alias + "."));
        stringBuilder.append(" ");
    }

    @Override
    protected void renderFrom(StringBuilder stringBuilder) {
        String alias = this.nameSolver.alias(this.clazz);
        stringBuilder.append("FROM ");
        stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMapper().getTableMap().getTableNameWithSchema());
        stringBuilder.append(" ");
        stringBuilder.append(alias);
        stringBuilder.append(" ");
        this.join().renderSql(stringBuilder);
        if (this.joinClasses != null && this.joinClasses.length > 0) {
            for (Class<?> joinClass : this.joinClasses) {
                stringBuilder.append(", ");
                stringBuilder.append(this.ormClassToolMap.getOrmClassTool(joinClass).getClassMapper().getTableMap().getTableNameWithSchema());
                stringBuilder.append(" ");
                stringBuilder.append(this.nameSolver.alias(joinClass));
            }
            stringBuilder.append(" ");
        }
    }

    @Override
    protected void renderWhere(StringBuilder stringBuilder) {
        this.where().renderSql(stringBuilder);
    }

    @Override
    protected void renderOrderBy(StringBuilder stringBuilder) {
        this.orderBy().renderSql(stringBuilder);
    }

    @Override
    protected void renderLockMode(StringBuilder stringBuilder) {
        stringBuilder.append(this.lockMode.getLockMode());
    }

    @Override
    public boolean isDistinct() throws OrmException {
        return this.distinct;
    }

    @Override
    public IOrmQuery<T> setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }
}

