/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query;

import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.ISelectClause;
import com.jpattern.orm.query.NullNameSolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SelectClause
implements ISelectClause {
    private static Pattern patternProperty = Pattern.compile("[a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+|[a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+");
    private final String selectClause;
    private INameSolver nameSolver = new NullNameSolver();

    public SelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    @Override
    public String renderSql() {
        StringBuilder query = new StringBuilder();
        this.renderSql(query);
        return query.toString();
    }

    @Override
    public void renderSql(StringBuilder StringBuilder2) {
        StringBuilder2.append("SELECT ");
        this.solveProperties(StringBuilder2, this.selectClause);
        StringBuilder2.append(" ");
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    private void solveProperties(StringBuilder StringBuilder2, String token) {
        Matcher m = patternProperty.matcher(token);
        int beginIndex = 0;
        while (m.find()) {
            StringBuilder2.append(token.substring(beginIndex, m.start()));
            StringBuilder2.append(this.nameSolver.solvePropertyName(m.group(), m.group()));
            beginIndex = m.end();
        }
        StringBuilder2.append(token.substring(beginIndex, token.length()));
    }
}

