/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ASqlPerformer;
import com.jpattern.orm.session.IGeneratedKeyReader;
import com.jpattern.orm.session.IPreparedStatementCreator;
import com.jpattern.orm.session.IResultSetReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DataSourceSqlPerformer
extends ASqlPerformer {
    private final Connection conn;
    private int queryTimeout = 0;
    private int maxRows = 0;

    public DataSourceSqlPerformer(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void execute(String sql) throws OrmException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
            preparedStatement.execute();
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        }
    }

    @Override
    public <T> T query(String sql, IResultSetReader<T> rse, Object ... args) throws OrmException {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(sql);
            int i = 0;
            for (Object value : args) {
                preparedStatement.setObject(++i, value);
            }
            preparedStatement.setMaxRows(this.getMaxRows());
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
            resultSet = preparedStatement.executeQuery();
            T t = rse.read(resultSet);
            return t;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            try {
                if (resultSet != null && !resultSet.isClosed()) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        }
    }

    @Override
    public int update(String sql, Object ... args) throws OrmException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
            int i = 0;
            for (Object value : args) {
                preparedStatement.setObject(++i, value);
            }
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        }
    }

    @Override
    public int update(String sql, IGeneratedKeyReader generatedKeyExtractor, Object ... args) throws OrmException {
        ResultSet generatedKeyResultSet = null;
        PreparedStatement preparedStatement = null;
        int result = 0;
        try {
            preparedStatement = this.conn.prepareStatement(sql, generatedKeyExtractor.generatedColumnNames());
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
            int i = 0;
            for (Object value : args) {
                preparedStatement.setObject(++i, value);
            }
            result = preparedStatement.executeUpdate();
            generatedKeyResultSet = preparedStatement.getGeneratedKeys();
            generatedKeyExtractor.read(generatedKeyResultSet);
            int n = result;
            return n;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (generatedKeyResultSet != null && !generatedKeyResultSet.isClosed()) {
                    generatedKeyResultSet.close();
                }
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        }
    }

    @Override
    public int[] batchUpdate(List<String> sqls) throws OrmException {
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            statement.setQueryTimeout(this.getQueryTimeout());
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            Object i$ = statement.executeBatch();
            return i$;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        }
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> args) throws OrmException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
            for (Object[] arg : args) {
                int i = 0;
                for (Object value : arg) {
                    preparedStatement.setObject(++i, value);
                }
                preparedStatement.addBatch();
            }
            Object i$ = preparedStatement.executeBatch();
            return i$;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        }
    }

    @Override
    public int[] batchUpdate(String sql, IPreparedStatementCreator psc) throws OrmException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
            for (int i = 0; i < psc.getBatchSize(); ++i) {
                psc.set(preparedStatement, i);
                preparedStatement.addBatch();
            }
            int[] i = preparedStatement.executeBatch();
            return i;
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        }
    }
}

