/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.jdbctemplate;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ASession;
import com.jpattern.orm.session.ISqlPerformer;
import com.jpattern.orm.session.ITransaction;
import com.jpattern.orm.session.TransactionIsolation;
import com.jpattern.orm.session.jdbctemplate.JdbcTemplateSqlPerformer;
import com.jpattern.orm.session.jdbctemplate.JdbcTemplateTransaction;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateSession
extends ASession {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformTransactionManager platformTransactionManager;

    public JdbcTemplateSession(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager, IOrmClassToolMap ormClassToolMap) {
        super(ormClassToolMap);
        this.jdbcTemplate = jdbcTemplate;
        this.platformTransactionManager = platformTransactionManager;
    }

    @Override
    public ITransaction beginTransaction() throws OrmException {
        try {
            return new JdbcTemplateTransaction(this.platformTransactionManager, -1);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public ITransaction beginTransaction(TransactionIsolation transactionIsolation) throws OrmException {
        try {
            return new JdbcTemplateTransaction(this.platformTransactionManager, transactionIsolation.getTransactionIsolation());
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void close() throws OrmException {
    }

    @Override
    public ISqlPerformer sqlPerformer() throws OrmException {
        return new JdbcTemplateSqlPerformer(this.jdbcTemplate);
    }
}

