/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.FeatureFlag;
import io.swagger.client.model.FeatureFlagBody;
import io.swagger.client.model.FeatureFlagStatus;
import io.swagger.client.model.FeatureFlagStatuses;
import io.swagger.client.model.FeatureFlags;
import io.swagger.client.model.PatchDelta;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FlagsApi {
    private ApiClient apiClient;

    public FlagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FlagsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteFeatureFlagCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteFeatureFlag(Async)");
        }
        Call call = this.deleteFeatureFlagCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFeatureFlag(String projectKey, String featureFlagKey) throws ApiException {
        this.deleteFeatureFlagWithHttpInfo(projectKey, featureFlagKey);
    }

    public ApiResponse<Void> deleteFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        Call call = this.deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFeatureFlagAsync(String projectKey, String featureFlagKey, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getFeatureFlagCall(String projectKey, String featureFlagKey, String environmentKeyQuery, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (environmentKeyQuery != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "environmentKeyQuery", environmentKeyQuery));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKeyQuery, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlag(Async)");
        }
        Call call = this.getFeatureFlagCall(projectKey, featureFlagKey, environmentKeyQuery, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlag getFeatureFlag(String projectKey, String featureFlagKey, String environmentKeyQuery) throws ApiException {
        ApiResponse<FeatureFlag> resp = this.getFeatureFlagWithHttpInfo(projectKey, featureFlagKey, environmentKeyQuery);
        return resp.getData();
    }

    public ApiResponse<FeatureFlag> getFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, String environmentKeyQuery) throws ApiException {
        Call call = this.getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, environmentKeyQuery, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagAsync(String projectKey, String featureFlagKey, String environmentKeyQuery, final ApiCallback<FeatureFlag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, environmentKeyQuery, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagStatusCall(String projectKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flag-statuses/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagStatusValidateBeforeCall(String projectKey, String environmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatus(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatus(Async)");
        }
        Call call = this.getFeatureFlagStatusCall(projectKey, environmentKey, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagStatuses getFeatureFlagStatus(String projectKey, String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagStatuses> resp = this.getFeatureFlagStatusWithHttpInfo(projectKey, environmentKey);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagStatuses> getFeatureFlagStatusWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        Call call = this.getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagStatusAsync(String projectKey, String environmentKey, final ApiCallback<FeatureFlagStatuses> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagStatusesCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flag-statuses/{projectKey}/{environmentKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagStatusesValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatuses(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatuses(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlagStatuses(Async)");
        }
        Call call = this.getFeatureFlagStatusesCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagStatus getFeatureFlagStatuses(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<FeatureFlagStatus> resp = this.getFeatureFlagStatusesWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagStatus> getFeatureFlagStatusesWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        Call call = this.getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagStatusesAsync(String projectKey, String environmentKey, String featureFlagKey, final ApiCallback<FeatureFlagStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagsCall(String projectKey, String environmentKeyQuery, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (environmentKeyQuery != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "environmentKeyQuery", environmentKeyQuery));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag", tag));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagsValidateBeforeCall(String projectKey, String environmentKeyQuery, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlags(Async)");
        }
        Call call = this.getFeatureFlagsCall(projectKey, environmentKeyQuery, tag, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlags getFeatureFlags(String projectKey, String environmentKeyQuery, String tag) throws ApiException {
        ApiResponse<FeatureFlags> resp = this.getFeatureFlagsWithHttpInfo(projectKey, environmentKeyQuery, tag);
        return resp.getData();
    }

    public ApiResponse<FeatureFlags> getFeatureFlagsWithHttpInfo(String projectKey, String environmentKeyQuery, String tag) throws ApiException {
        Call call = this.getFeatureFlagsValidateBeforeCall(projectKey, environmentKeyQuery, tag, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagsAsync(String projectKey, String environmentKeyQuery, String tag, final ApiCallback<FeatureFlags> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagsValidateBeforeCall(projectKey, environmentKeyQuery, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchFeatureFlagCall(String projectKey, String featureFlagKey, List<PatchDelta> patchDelta, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<PatchDelta> localVarPostBody = patchDelta;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, List<PatchDelta> patchDelta, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchFeatureFlag(Async)");
        }
        if (patchDelta == null) {
            throw new ApiException("Missing the required parameter 'patchDelta' when calling patchFeatureFlag(Async)");
        }
        Call call = this.patchFeatureFlagCall(projectKey, featureFlagKey, patchDelta, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlag patchFeatureFlag(String projectKey, String featureFlagKey, List<PatchDelta> patchDelta) throws ApiException {
        ApiResponse<FeatureFlag> resp = this.patchFeatureFlagWithHttpInfo(projectKey, featureFlagKey, patchDelta);
        return resp.getData();
    }

    public ApiResponse<FeatureFlag> patchFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, List<PatchDelta> patchDelta) throws ApiException {
        Call call = this.patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchDelta, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchFeatureFlagAsync(String projectKey, String featureFlagKey, List<PatchDelta> patchDelta, final ApiCallback<FeatureFlag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchDelta, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postFeatureFlagCall(String projectKey, FeatureFlagBody featureFlagBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FeatureFlagBody localVarPostBody = featureFlagBody;
        String localVarPath = "/flags/{projectKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postFeatureFlagValidateBeforeCall(String projectKey, FeatureFlagBody featureFlagBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postFeatureFlag(Async)");
        }
        if (featureFlagBody == null) {
            throw new ApiException("Missing the required parameter 'featureFlagBody' when calling postFeatureFlag(Async)");
        }
        Call call = this.postFeatureFlagCall(projectKey, featureFlagBody, progressListener, progressRequestListener);
        return call;
    }

    public void postFeatureFlag(String projectKey, FeatureFlagBody featureFlagBody) throws ApiException {
        this.postFeatureFlagWithHttpInfo(projectKey, featureFlagBody);
    }

    public ApiResponse<Void> postFeatureFlagWithHttpInfo(String projectKey, FeatureFlagBody featureFlagBody) throws ApiException {
        Call call = this.postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, null, null);
        return this.apiClient.execute(call);
    }

    public Call postFeatureFlagAsync(String projectKey, FeatureFlagBody featureFlagBody, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

