/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Variation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FeatureFlagBody {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="variations")
    private List<Variation> variations = new ArrayList<Variation>();
    @SerializedName(value="temporary")
    private Boolean temporary = null;
    @SerializedName(value="tags")
    private List<String> tags = null;
    @SerializedName(value="includeInSnippet")
    private Boolean includeInSnippet = null;

    public FeatureFlagBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="A human-friendly name for the feature flag. Remember to note if this flag is intended to be temporary or permanent.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FeatureFlagBody key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique key that will be used to reference the flag in your code")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public FeatureFlagBody variations(List<Variation> variations) {
        this.variations = variations;
        return this;
    }

    public FeatureFlagBody addVariationsItem(Variation variationsItem) {
        this.variations.add(variationsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of possible variations for the flag.")
    public List<Variation> getVariations() {
        return this.variations;
    }

    public void setVariations(List<Variation> variations) {
        this.variations = variations;
    }

    public FeatureFlagBody temporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @ApiModelProperty(value="Whether or not the flag is a temporary flag")
    public Boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public FeatureFlagBody tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public FeatureFlagBody addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tags for the feature flag")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public FeatureFlagBody includeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
        return this;
    }

    @ApiModelProperty(value="Whether or not this flag should be made available to the client-side JavaScript SDK")
    public Boolean getIncludeInSnippet() {
        return this.includeInSnippet;
    }

    public void setIncludeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlagBody featureFlagBody = (FeatureFlagBody)o;
        return Objects.equals(this.name, featureFlagBody.name) && Objects.equals(this.key, featureFlagBody.key) && Objects.equals(this.variations, featureFlagBody.variations) && Objects.equals(this.temporary, featureFlagBody.temporary) && Objects.equals(this.tags, featureFlagBody.tags) && Objects.equals(this.includeInSnippet, featureFlagBody.includeInSnippet);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.variations, this.temporary, this.tags, this.includeInSnippet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureFlagBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    temporary: ").append(this.toIndentedString(this.temporary)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    includeInSnippet: ").append(this.toIndentedString(this.includeInSnippet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

