/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.ehcache;

import com.litongjava.cache.CacheableModel;
import com.litongjava.ehcache.CacheKit;
import com.litongjava.jfinal.aop.Interceptor;
import com.litongjava.jfinal.aop.Invocation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class EcacheCacheInterceptor
implements Interceptor {
    private static ConcurrentHashMap<String, ReentrantLock> lockMap = new ConcurrentHashMap(512);

    private ReentrantLock getLock(String key) {
        ReentrantLock lock = lockMap.get(key);
        if (lock != null) {
            return lock;
        }
        lock = new ReentrantLock();
        ReentrantLock previousLock = lockMap.putIfAbsent(key, lock);
        return previousLock == null ? lock : previousLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void intercept(Invocation inv) {
        String cacheKey;
        Object target = inv.getTarget();
        CacheableModel cacheableModel = CacheableModel.buildCacheModel(inv, target);
        String cacheName = cacheableModel.getName();
        Object cacheData = CacheKit.get(cacheName, cacheKey = cacheableModel.getKey());
        if (cacheData == null) {
            ReentrantLock lock = this.getLock(cacheName);
            lock.lock();
            try {
                cacheData = CacheKit.get(cacheName, cacheKey);
                if (cacheData == null) {
                    Object returnValue = inv.invoke();
                    this.cacheMethodReturnValue(cacheName, cacheKey, returnValue);
                    return;
                }
            }
            finally {
                lock.unlock();
            }
        }
        inv.setReturnValue(cacheData);
    }

    protected void cacheMethodReturnValue(String cacheName, String cacheKey, Object returnValue) {
        CacheKit.put(cacheName, cacheKey, returnValue);
    }
}

