/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.jfinal.kit.StrKit;
import com.litongjava.cache.ICache;
import com.litongjava.db.activerecord.ActiveRecordException;
import com.litongjava.db.activerecord.IContainerFactory;
import com.litongjava.db.activerecord.IDbProFactory;
import com.litongjava.db.activerecord.SqlReporter;
import com.litongjava.db.activerecord.bean.DefaultRecordConvert;
import com.litongjava.db.activerecord.bean.RecordConvert;
import com.litongjava.db.activerecord.cache.DefaultEhCache;
import com.litongjava.db.activerecord.dialect.Dialect;
import com.litongjava.db.activerecord.dialect.MysqlDialect;
import com.litongjava.db.activerecord.sql.SqlKit;
import com.litongjava.db.activerecord.stat.ISqlStatementStat;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private final ThreadLocal<Connection> threadLocal = new ThreadLocal();
    String name;
    DataSource dataSource;
    Dialect dialect;
    boolean showSql;
    boolean devMode;
    int transactionLevel;
    IContainerFactory containerFactory;
    IDbProFactory dbProFactory = IDbProFactory.defaultDbProFactory;
    ICache cache;
    SqlKit sqlKit;
    ISqlStatementStat stat;
    boolean writeSync;
    private RecordConvert recordConvert;

    public Config(String name, DataSource dataSource, int transactionLevel) {
        this.init(name, dataSource, new MysqlDialect(), false, false, transactionLevel, IContainerFactory.defaultContainerFactory, new DefaultEhCache());
    }

    public Config(String name, DataSource dataSource, Dialect dialect, boolean showSql, boolean devMode, int transactionLevel, IContainerFactory containerFactory, ICache cache) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        this.init(name, dataSource, dialect, showSql, devMode, transactionLevel, containerFactory, cache);
    }

    private void init(String name, DataSource dataSource, Dialect dialect, boolean showSql, boolean devMode, int transactionLevel, IContainerFactory containerFactory, ICache cache) {
        if (StrKit.isBlank((String)name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dialect == null) {
            throw new IllegalArgumentException("Dialect can not be null");
        }
        if (containerFactory == null) {
            throw new IllegalArgumentException("ContainerFactory can not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Cache can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.showSql = showSql;
        this.devMode = devMode;
        this.setTransactionLevel(transactionLevel);
        this.containerFactory = containerFactory;
        this.cache = cache;
        this.sqlKit = new SqlKit(this.name, this.devMode);
    }

    public Config(String name, DataSource dataSource) {
        this(name, dataSource, new MysqlDialect());
    }

    public Config(String name, DataSource dataSource, Dialect dialect) {
        this(name, dataSource, dialect, false, false, 4, IContainerFactory.defaultContainerFactory, new DefaultEhCache());
    }

    private Config() {
    }

    void setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.sqlKit.setDevMode(devMode);
    }

    void setTransactionLevel(int transactionLevel) {
        int t = transactionLevel;
        if (t != 0 && t != 1 && t != 2 && t != 4 && t != 8) {
            throw new IllegalArgumentException("The transactionLevel only be 0, 1, 2, 4, 8");
        }
        this.transactionLevel = transactionLevel;
    }

    public void setSqlStatementStat(ISqlStatementStat stat, boolean writeSync) {
        this.stat = stat;
        this.writeSync = writeSync;
    }

    public ISqlStatementStat getSqlStatementStat() {
        return this.stat;
    }

    public boolean writeSync() {
        return this.writeSync;
    }

    static Config createBrokenConfig() {
        Config ret = new Config();
        ret.dialect = new MysqlDialect();
        ret.showSql = false;
        ret.devMode = false;
        ret.transactionLevel = 4;
        ret.containerFactory = IContainerFactory.defaultContainerFactory;
        ret.cache = new DefaultEhCache();
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public SqlKit getSqlKit() {
        return this.sqlKit;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public ICache getCache() {
        return this.cache;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public IContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public IDbProFactory getDbProFactory() {
        return this.dbProFactory;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setThreadLocalConnection(Connection connection) {
        this.threadLocal.set(connection);
    }

    public void removeThreadLocalConnection() {
        this.threadLocal.remove();
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.threadLocal.get();
        if (conn != null) {
            return conn;
        }
        Connection rawConnection = this.dataSource.getConnection();
        if (this.showSql) {
            return new SqlReporter(rawConnection).getConnection();
        }
        return rawConnection;
    }

    public Connection getThreadLocalConnection() {
        return this.threadLocal.get();
    }

    public boolean isInTransaction() {
        return this.threadLocal.get() != null;
    }

    public void close(ResultSet rs, Statement st, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public void close(Statement st, Connection conn) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public void close(Connection conn) {
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConvert getRecordConvert() {
        if (this.recordConvert == null) {
            String string = this.name;
            synchronized (string) {
                if (this.recordConvert == null) {
                    this.recordConvert = new DefaultRecordConvert();
                }
            }
        }
        return this.recordConvert;
    }

    public void setRecordConvert(RecordConvert convert) {
        this.recordConvert = convert;
    }
}

