/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.generator;

import com.jfinal.kit.JavaKeyword;
import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.template.Engine;
import com.litongjava.db.activerecord.generator.TableMeta;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseModelGenerator {
    protected Engine engine;
    protected String template = "/com/litongjava/jfinal/plugin/activerecord/generator/base_model_template.jf";
    protected String baseModelPackageName;
    protected String baseModelOutputDir;
    protected boolean generateChainSetter = false;
    protected JavaKeyword javaKeyword = JavaKeyword.me;
    protected Map<String, String> getterTypeMap = new HashMap<String, String>(){
        {
            this.put("java.lang.String", "getStr");
            this.put("java.lang.Integer", "getInt");
            this.put("java.lang.Long", "getLong");
            this.put("java.lang.Double", "getDouble");
            this.put("java.lang.Float", "getFloat");
            this.put("java.lang.Short", "getShort");
            this.put("java.lang.Byte", "getByte");
            this.put("java.util.Date", "getDate");
            this.put("java.time.LocalDateTime", "getLocalDateTime");
            this.put("java.lang.Boolean", "getBoolean");
            this.put("java.math.BigDecimal", "getBigDecimal");
            this.put("java.math.BigInteger", "getBigInteger");
        }
    };

    public BaseModelGenerator(String baseModelPackageName, String baseModelOutputDir) {
        if (StrKit.isBlank((String)baseModelPackageName)) {
            throw new IllegalArgumentException("baseModelPackageName can not be blank.");
        }
        if (baseModelPackageName.contains("/") || baseModelPackageName.contains("\\")) {
            throw new IllegalArgumentException("baseModelPackageName error : " + baseModelPackageName);
        }
        if (StrKit.isBlank((String)baseModelOutputDir)) {
            throw new IllegalArgumentException("baseModelOutputDir can not be blank.");
        }
        this.baseModelPackageName = baseModelPackageName;
        this.baseModelOutputDir = baseModelOutputDir;
        this.initEngine();
    }

    protected void initEngine() {
        this.engine = new Engine();
        this.engine.setToClassPathSourceFactory();
        this.engine.addSharedMethod((Object)new StrKit());
        this.engine.addSharedObject("getterTypeMap", this.getterTypeMap);
        this.engine.addSharedObject("javaKeyword", (Object)this.javaKeyword);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setGenerateChainSetter(boolean generateChainSetter) {
        this.generateChainSetter = generateChainSetter;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate base model ...");
        System.out.println("Base Model Output Dir: " + this.baseModelOutputDir);
        for (TableMeta tableMeta : tableMetas) {
            this.genBaseModelContent(tableMeta);
        }
        this.writeToFile(tableMetas);
    }

    protected void genBaseModelContent(TableMeta tableMeta) {
        Kv data = Kv.by((Object)"baseModelPackageName", (Object)this.baseModelPackageName);
        data.set((Object)"generateChainSetter", (Object)this.generateChainSetter);
        data.set((Object)"tableMeta", (Object)tableMeta);
        tableMeta.baseModelContent = this.engine.getTemplate(this.template).renderToString((Map)data);
    }

    protected void writeToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.writeToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeToFile(TableMeta tableMeta) throws IOException {
        File dir = new File(this.baseModelOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String target = this.baseModelOutputDir + File.separator + tableMeta.baseModelName + ".java";
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(target), "UTF-8");){
            osw.write(tableMeta.baseModelContent);
        }
    }

    public String getBaseModelPackageName() {
        return this.baseModelPackageName;
    }

    public String getBaseModelOutputDir() {
        return this.baseModelOutputDir;
    }
}

