/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.Record;
import com.litongjava.db.activerecord.builder.BuilderKit;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class RecordBuilder {
    public static final RecordBuilder me = new RecordBuilder();

    public List<Record> build(Config config, ResultSet rs) throws SQLException {
        return this.build(config, rs, null);
    }

    public List<Record> buildJsonFields(Config config, ResultSet rs, String[] jsonFields) throws SQLException {
        return this.buildJsonFields(config, rs, jsonFields, null);
    }

    public List<Record> build(Config config, ResultSet rs, Function<Record, Boolean> func) throws SQLException {
        ArrayList<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Record record = new Record();
            record.setColumnsMap(config.containerFactory.getColumnsMap());
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = BuilderKit.getColumnValue(types, rs, i);
                columns.put(labelNames[i], value);
            }
            if (func == null) {
                result.add(record);
                continue;
            }
            if (func.apply(record).booleanValue()) continue;
            break;
        }
        return result;
    }

    public List<Record> buildJsonFields(Config config, ResultSet rs, String[] jsonFields, Function<Record, Boolean> func) throws SQLException {
        ArrayList<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Record record = new Record();
            record.setColumnsMap(config.containerFactory.getColumnsMap());
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = BuilderKit.getColumnValue(types, rs, i);
                String labelName = labelNames[i];
                for (String jsonField : jsonFields) {
                    if (!labelName.equals(jsonField) || value == null || !(value instanceof String)) continue;
                    String stringValue = (String)value;
                    value = BuilderKit.parseJsonField(stringValue);
                }
                columns.put(labelName, value);
            }
            if (func == null) {
                result.add(record);
                continue;
            }
            if (func.apply(record).booleanValue()) continue;
            break;
        }
        return result;
    }

    public void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }
}

