/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.result;

import java.io.Serializable;

public class OkResult<T>
implements Serializable {
    private static final long serialVersionUID = -4806033278155820866L;
    private T v;
    private boolean ok = true;
    private Exception e;
    private String message;

    public OkResult(boolean b) {
        this.ok = b;
    }

    public OkResult(boolean b, T value) {
        this.ok = b;
        this.v = value;
    }

    public OkResult(boolean b, String message) {
        this.ok = b;
        this.message = message;
    }

    public OkResult(boolean b, Exception e) {
        this.ok = b;
        this.e = e;
        this.message = e.getMessage();
    }

    public Long getLong() {
        return this.v != null ? (Long)this.v : null;
    }

    public String getString() {
        return this.v != null ? (String)this.v : null;
    }

    public Integer getInteger() {
        return this.v != null ? (Integer)this.v : null;
    }

    public static OkResult fail() {
        return new OkResult(false);
    }

    public static OkResult exception(Exception e) {
        return new OkResult(false, e);
    }

    public static <T> OkResult<T> ok(T value) {
        return new OkResult<T>(true, value);
    }

    public static <T> OkResult<T> fail(String value) {
        return new OkResult<T>(false, value);
    }

    public OkResult<T> notOk() {
        this.ok = false;
        return this;
    }

    public OkResult<T> notOk(Exception e) {
        this.ok = false;
        this.e = e;
        return this;
    }

    public boolean isNotOk() {
        return !this.ok;
    }

    public T getResult() {
        return this.v;
    }

    public T getV() {
        return this.v;
    }

    public boolean isOk() {
        return this.ok;
    }

    public Exception getE() {
        return this.e;
    }

    public String getMessage() {
        return this.message;
    }

    public OkResult<T> setV(T v) {
        this.v = v;
        return this;
    }

    public OkResult<T> setOk(boolean ok) {
        this.ok = ok;
        return this;
    }

    public OkResult<T> setE(Exception e) {
        this.e = e;
        return this;
    }

    public OkResult<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkResult)) {
            return false;
        }
        OkResult other = (OkResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOk() != other.isOk()) {
            return false;
        }
        T this$v = this.getV();
        T other$v = other.getV();
        if (this$v == null ? other$v != null : !this$v.equals(other$v)) {
            return false;
        }
        Exception this$e = this.getE();
        Exception other$e = other.getE();
        if (this$e == null ? other$e != null : !this$e.equals(other$e)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OkResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOk() ? 79 : 97);
        T $v = this.getV();
        result = result * 59 + ($v == null ? 43 : $v.hashCode());
        Exception $e = this.getE();
        result = result * 59 + ($e == null ? 43 : $e.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "OkResult(v=" + this.getV() + ", ok=" + this.isOk() + ", e=" + this.getE() + ", message=" + this.getMessage() + ")";
    }

    public OkResult() {
    }

    public OkResult(T v, boolean ok, Exception e, String message) {
        this.v = v;
        this.ok = ok;
        this.e = e;
        this.message = message;
    }
}

