/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.chart.common.CommonSample;
import com.loadcoder.load.chart.common.CommonSampleGroup;
import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.common.CommonSeriesCalculator;
import com.loadcoder.load.chart.common.CommonYCalculator;
import com.loadcoder.load.chart.common.YCalculator;
import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.FilteredData;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.load.chart.data.Range;
import com.loadcoder.load.chart.jfreechart.ItemSeriesAdder;
import com.loadcoder.load.chart.jfreechart.XYDottedSeriesExtension;
import com.loadcoder.load.chart.jfreechart.XYPlotExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesCollectionExtention;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.sampling.Sample;
import com.loadcoder.load.chart.sampling.SampleGroup;
import com.loadcoder.load.chart.utilities.ColorUtils;
import com.loadcoder.load.jfreechartfixes.XYLineAndShapeRendererExtention;
import com.loadcoder.result.Result;
import com.loadcoder.result.TransactionExecutionResult;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.LegendItem;

public abstract class ChartLogic {
    List<XYSeriesExtension> commonSeries = new ArrayList<XYSeriesExtension>();
    Map<Comparable, XYSeriesExtension> seriesCommonMap = new HashMap<Comparable, XYSeriesExtension>();
    CommonSeries[] commonsToBeUsed = CommonSeries.values();
    protected Long earliestX;
    protected long highestX = 0L;
    protected long sampleLengthToUse;
    final boolean locked;
    FilteredData filteredData;
    List<DataSetUserType> removalFiltersInUse = new ArrayList<DataSetUserType>();
    protected final XYSeriesCollectionExtention seriesCollection;
    protected final XYPlotExtension plot;
    protected final XYLineAndShapeRendererExtention renderer;
    protected final Map<Comparable, Boolean> seriesVisible;
    protected List<YCalculator> yCalculators = new ArrayList<YCalculator>();
    public YCalculator yCalculatorToUse = YCalculator.avg;
    List<Color> existingColors = new ArrayList<Color>();
    Map<Comparable, Color> customizedColors;
    protected List<Comparable> seriesKeys = new ArrayList<Comparable>();
    protected Map<Comparable, LegendItem> legends = new HashMap<Comparable, LegendItem>();
    protected List<CommonSeriesCalculator> commonSeriesCalculators = new ArrayList<CommonSeriesCalculator>();
    protected List<Range> ranges = new ArrayList<Range>();
    protected boolean shallUpdate = true;

    protected abstract void getDataAndUpdate(HashSet<Long> var1, boolean var2);

    protected abstract void update(List<List<TransactionExecutionResult>> var1, HashSet<Long> var2, boolean var3);

    protected abstract void doUpdate();

    protected long getXDiff() {
        if (this.earliestX == null) {
            return 0L;
        }
        long xDiff = this.highestX - this.earliestX;
        return xDiff;
    }

    protected Range lookupCorrectRange(long ts) {
        for (Range range : this.ranges) {
            if (!range.isTimestampInThisRange(ts)) continue;
            return range;
        }
        throw new RuntimeException("No range was found for timestamp " + ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSafeUpdate() {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            this.doUpdate();
            long xDiff = this.getXDiff();
            if (xDiff > 82800000L) {
                this.plot.changeToMonthAndDayDateAxisFormat();
            }
        }
    }

    public List<DataSetUserType> getRemovalFiltersInUse() {
        return this.removalFiltersInUse;
    }

    public void setRemovalFiltersInUse(List<DataSetUserType> removalFiltersInUse) {
        this.removalFiltersInUse = removalFiltersInUse;
    }

    public void setFilteredData(FilteredData filteredData) {
        this.filteredData = filteredData;
    }

    public FilteredData getFilteredData() {
        return this.filteredData;
    }

    public long getSampleLengthToUse() {
        return this.sampleLengthToUse;
    }

    public void setSampleLengthToUse(long sampleLengthToUse) {
        this.sampleLengthToUse = sampleLengthToUse;
    }

    public List<YCalculator> getyCalculators() {
        return this.yCalculators;
    }

    public void setyCalculators(List<YCalculator> yCalculators) {
        this.yCalculators = yCalculators;
    }

    void addToSeriesKeys(FilteredData filteredData, List<Comparable> seriesKeys) {
        for (DataSet dataSet : filteredData.getDataSets()) {
            String s = dataSet.getName();
            if (seriesKeys.contains(s)) continue;
            seriesKeys.add((Comparable)((Object)s));
        }
    }

    public ChartLogic(XYSeriesCollectionExtention seriesCollection, XYPlotExtension plot, XYLineAndShapeRendererExtention renderer, Map<Comparable, Boolean> seriesVisible, boolean locked) {
        this.locked = locked;
        this.seriesCollection = seriesCollection;
        this.plot = plot;
        this.renderer = renderer;
        this.seriesVisible = seriesVisible;
        this.yCalculators.add(YCalculator.avg);
        this.yCalculators.add(YCalculator.max);
        this.populateColorArray();
    }

    public static void addSurroundingTimestampsAsUpdates(Set<Long> hashesGettingUpdated, long sampleStart, long earliest, long latest, List<Range> ranges, long currentSampleLength, Set<Long> sampleTimestamps, Map<Long, Sample> aboutToBeUpdated) {
        long iterator = sampleStart;
        while (earliest < iterator) {
            long lastTsInPrevious = iterator - 1L;
            long sampleLength = Range.findSampleLength(lastTsInPrevious, ranges);
            long firstTsInPrevious = SampleGroup.calculateFirstTs(lastTsInPrevious, sampleLength);
            boolean exists = false;
            if (sampleTimestamps.contains(firstTsInPrevious) || aboutToBeUpdated.containsKey(firstTsInPrevious)) {
                exists = true;
            }
            if (exists) break;
            if (!hashesGettingUpdated.contains(firstTsInPrevious)) {
                hashesGettingUpdated.add(firstTsInPrevious);
            }
            iterator = firstTsInPrevious;
        }
        iterator = sampleStart;
        while (latest > iterator) {
            long sampleLength = Range.findSampleLength(iterator, ranges);
            long firstTsInNext = iterator + sampleLength;
            boolean exists = false;
            if (sampleTimestamps.contains(firstTsInNext) || aboutToBeUpdated.containsKey(firstTsInNext)) {
                exists = true;
            }
            if (exists) break;
            if (!hashesGettingUpdated.contains(firstTsInNext)) {
                hashesGettingUpdated.add(firstTsInNext);
            }
            iterator = firstTsInNext;
        }
    }

    public void createCommons() {
        this.commonSeries = new ArrayList<XYSeriesExtension>();
        this.commonSeriesCalculators.clear();
        this.commonSeries.clear();
        this.seriesCommonMap.clear();
        Arrays.stream(this.commonsToBeUsed).forEach(common -> {
            XYSeriesExtension xySeries = new XYSeriesExtension((Comparable)((Object)common.getName()), true, false, common.getColor());
            this.seriesCommonMap.put((Comparable)((Object)common.getName()), xySeries);
            this.commonSeriesCalculators.add(new CommonSeriesCalculator(xySeries, common.getCommonYCalculator()));
            this.commonSeries.add(xySeries);
        });
    }

    public void addSeries(XYSeriesExtension serie) {
        this.seriesCollection.addSeries(serie);
        int indexOfSeries = this.seriesCollection.indexOf(serie);
        LegendItem legend = this.legends.get(serie.getKey());
        if (legend == null) {
            legend = this.plot.getRenderer().getLegendItem(0, indexOfSeries);
            this.legends.put(serie.getKey(), legend);
            this.plot.getLegendItems().add(legend);
        }
        serie.setLegend(legend);
    }

    public void removeSeries(XYSeriesExtension serie) {
        int indexOfSeries = this.seriesCollection.indexOf(serie);
        this.seriesCollection.removeSeries(indexOfSeries);
    }

    void updateCommonsWithSamples(HashSet<Long> hashesGettingUpdated, Map<Comparable, SampleGroup> sampleGroups, Map<Comparable, CommonSampleGroup> samplesCommonMap, List<CommonSampleGroup> sampleGroupCommonList) {
        for (Long l : hashesGettingUpdated) {
            for (CommonSeriesCalculator calc : this.commonSeriesCalculators) {
                XYSeriesExtension series = calc.getSeries();
                CommonYCalculator calculator = calc.getCalculator();
                Range r = this.getSampleLength(l);
                double amount = calculator.calculateCommonY(this.seriesKeys, l, sampleGroups, r.getSampleLength());
                Comparable commonKey = series.getKey();
                CommonSampleGroup commonSampleGroup = samplesCommonMap.get(commonKey);
                if (commonSampleGroup == null) {
                    commonSampleGroup = new CommonSampleGroup(series);
                    samplesCommonMap.put(commonKey, commonSampleGroup);
                    sampleGroupCommonList.add(commonSampleGroup);
                }
                CommonSample cs = commonSampleGroup.getAndCreateSample(l, (Comparable)((Object)((String)((Object)commonKey))), r.getSampleLength());
                long longAmount = Sample.amountToYValue(amount);
                cs.setY(longAmount);
                if (cs.getFirst() == null) {
                    cs.initDataItems();
                    series.add(cs.getFirst(), false);
                    continue;
                }
                cs.updateDataItems();
            }
        }
    }

    Paint getSeriesColor(Comparable dataSetName) {
        LegendItem legend = this.legends.get(dataSetName);
        Paint seriesColor = null;
        seriesColor = legend == null ? this.getNewColor(dataSetName) : legend.getFillPaint();
        return seriesColor;
    }

    void getSerieses(List<DataSet> dataSets, boolean dottedMode, Map<Comparable, XYSeriesExtension> seriesMap) {
        for (DataSet dataSet : dataSets) {
            String dataSetName = dataSet.getName();
            Paint seriesColor = this.getSeriesColor((Comparable)((Object)dataSetName));
            XYSeriesExtension seriesName = seriesMap.get(dataSetName);
            if (seriesName != null) continue;
            XYSeriesExtension serie = new XYSeriesExtension((Comparable)((Object)dataSetName), true, false, seriesColor);
            seriesMap.put((Comparable)((Object)dataSetName), serie);
        }
    }

    void adjustVisibilityOfSeries(XYSeriesExtension serie) {
        int indexOfSeries = this.seriesCollection.indexOf(serie);
        this.renderer.setSeriesShape(indexOfSeries, XYDottedSeriesExtension.DOTTEDSHAPE);
        Boolean visible = this.seriesVisible.get(serie.getKey());
        if (visible == null) {
            visible = true;
            this.seriesVisible.put(serie.getKey(), visible);
        }
        serie.setVisible(visible);
        this.renderer.setSeriesLinesVisible(indexOfSeries, visible);
        this.renderer.setSeriesShapesVisible(indexOfSeries, false);
    }

    void addPoints(List<DataSet> dataSets, Map<Comparable, SampleGroup> sampleGroups, Set<Long> sampleTimestamps) {
        long start = System.currentTimeMillis();
        for (DataSet dataSet : dataSets) {
            String dataSetName = dataSet.getName();
            SampleGroup sampleGroup = sampleGroups.get(dataSetName);
            XYSeriesExtension series = sampleGroup.getSeries();
            this.createSamplesAndAddPoints((Comparable)((Object)dataSetName), sampleGroup.getSeries(), dataSet, sampleGroup, sampleTimestamps);
        }
    }

    void createSamplesGroups(Map<Comparable, XYSeriesExtension> seriesMap, Map<Comparable, SampleGroup> sampleGroups) {
        for (Comparable key : this.seriesKeys) {
            XYSeriesExtension serie = seriesMap.get(key);
            SampleGroup sampleGroup = sampleGroups.get(key);
            if (sampleGroup != null) continue;
            sampleGroup = new SampleGroup(this.sampleLengthToUse, serie, this.locked);
            sampleGroups.put(key, sampleGroup);
        }
    }

    void createSamplesAndAddPoints(Comparable dataSetName, XYSeriesExtension serie, DataSet dataSet, SampleGroup sampleGroup, Set<Long> sampleTimestamps) {
        for (Point point : dataSet.getPoints()) {
            long x = point.getX();
            if (x > this.highestX) {
                this.highestX = x;
            }
            if (this.earliestX == null || x < this.earliestX) {
                this.earliestX = x;
                if (this.ranges.isEmpty()) {
                    Sample s = sampleGroup.getAndCreateSample(point.getX(), dataSetName, this.sampleLengthToUse);
                    this.ranges.add(new Range(s.getFirstTs(), Long.MAX_VALUE, this.sampleLengthToUse));
                } else {
                    Range r = this.ranges.get(this.ranges.size() - 1);
                    long sampleLengthOfTheLastAddedRange = r.getSampleLength();
                    Sample s = sampleGroup.getAndCreateSample(x, dataSetName, sampleLengthOfTheLastAddedRange);
                    r.setStart(s.getFirstTs());
                }
            }
            Range rangeToUse = this.getSampleLength(x);
            Sample s = sampleGroup.getAndCreateSample(point.getX(), dataSetName, rangeToUse.getSampleLength());
            if (!sampleTimestamps.contains(s.getFirstTs())) {
                sampleTimestamps.add(s.getFirstTs());
            }
            s.addPoint(point);
            if (!point.isStatus()) {
                s.increaseFails();
            }
            if (sampleGroup.getSamplesUnupdated().containsKey(s.getFirstTs())) continue;
            sampleGroup.getSamplesUnupdated().put(s.getFirstTs(), s);
        }
    }

    public void addAllCommonSeriesToTheChart() {
        for (XYSeriesExtension series : this.commonSeries) {
            this.addSeries(series);
            int indexOfSeries = this.seriesCollection.indexOf(series);
            Boolean visible = this.seriesVisible.get(series.getKey());
            if (visible == null || visible.booleanValue()) {
                this.renderer.setSeriesLinesVisible(indexOfSeries, true);
            } else {
                this.renderer.setSeriesLinesVisible(indexOfSeries, false);
            }
            this.renderer.setSeriesShapesVisible(indexOfSeries, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void useResult(Result r, List<List<TransactionExecutionResult>> listOfListOfList) {
        List transactionExecutionResults;
        List list = transactionExecutionResults = r.getResultLists();
        synchronized (list) {
            for (List listToBeCopiedAndCleared : transactionExecutionResults) {
                ArrayList newList = new ArrayList();
                listOfListOfList.add(newList);
                newList.addAll(listToBeCopiedAndCleared);
            }
        }
    }

    public Range getSampleLength(long timestamp) {
        for (Range range : this.ranges) {
            if (timestamp < range.getStart() || timestamp > range.getEnd()) continue;
            return range;
        }
        return null;
    }

    void populateColorArray() {
        if (this.customizedColors != null) {
            for (Map.Entry<Comparable, Color> e : this.customizedColors.entrySet()) {
                this.existingColors.add(e.getValue());
            }
        }
        for (CommonSeries commonSerie : this.commonsToBeUsed) {
            Color c = commonSerie.getColor();
            this.existingColors.add(c);
        }
    }

    public synchronized Color getNewColor(Comparable seriesKey) {
        if (this.customizedColors != null) {
            Color color = this.customizedColors.get(seriesKey);
            return color;
        }
        Color newColor = ColorUtils.getNewContrastfulColor(this.existingColors);
        this.existingColors.add(newColor);
        return newColor;
    }

    void forceRerender() {
        this.seriesCollection.fireChange();
    }

    void updateSeriesWithSamples(ItemSeriesAdder itemSeriesAdder, Set<Long> hashesGettingUpdated, List<DataSet> dataSets, Map<Comparable, SampleGroup> sampleGroups, Set<Long> sampleTimestamps) {
        for (Comparable key : this.seriesKeys) {
            SampleGroup group = sampleGroups.get(key);
            XYSeriesExtension series = group.getSeries();
            Set<Long> aboutToBeUpdatedKeys = group.getSamplesUnupdated().keySet();
            for (Long unupdatedSampleKey : aboutToBeUpdatedKeys) {
                long l;
                Sample sample = group.getSamplesUnupdated().get(unupdatedSampleKey);
                sample.calculateY(this.yCalculatorToUse);
                double y = sample.getY();
                if (y != -1.0) {
                    itemSeriesAdder.add(series, sample);
                }
                if (!hashesGettingUpdated.contains(l = sample.getFirstTs())) {
                    hashesGettingUpdated.add(l);
                }
                long[] minmaxPoints = this.filteredData.getMinmaxPoints();
                long earliest = minmaxPoints[0];
                long latest = minmaxPoints[1];
                ChartLogic.addSurroundingTimestampsAsUpdates(hashesGettingUpdated, l, earliest, latest, this.ranges, sample.getLength(), sampleTimestamps, group.getSamplesUnupdated());
            }
            group.getSamplesUnupdated().clear();
        }
    }
}

