/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.common.YCalculator;
import com.loadcoder.load.chart.logic.Chart;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.logic.ResultChartLogic;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.menu.SteppingSlider;
import com.loadcoder.load.chart.utilities.ChartUtils;
import com.loadcoder.result.Result;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;

public class ResultChart
extends Chart {
    private static final boolean defaultDottedMode = false;
    final ResultChartLogic logic;
    Result[] results;
    final CommonSeries[] commonSeries;

    public ResultChart(Map<Comparable, Color> customizedColors, CommonSeries[] commonSeries, Result ... results) {
        super(true, false);
        this.logic = new ResultChartLogic(this.chartFrame.getSeriesCollection(), this.chartFrame.getPlot(), this.chartFrame.getRenderer(), this.chartFrame.getSeriesVisible(), false, commonSeries, customizedColors, false, results);
        long sampleLengthToUse = this.logic.getSampleLengthToUse();
        int minorTickPacing = this.logic.getMinorTickLength();
        int defaultIndex = this.logic.getDefaultSliderIndex();
        this.addResultMenu(sampleLengthToUse, defaultIndex);
        this.chartFrame.setVisible(true);
        this.results = results;
        this.commonSeries = commonSeries;
    }

    public ResultChart(CommonSeries[] commonSeries, Result ... results) {
        this(null, commonSeries, results);
    }

    public ResultChart(Result ... results) {
        this(CommonSeries.values(), results);
        this.results = results;
    }

    protected ChartLogic getLogic() {
        return this.logic;
    }

    private void toggleRemoveFilterCheckBox(DataSetUserType dataSetUserType, boolean selected) {
        this.logic.setFilteredData(null);
        this.logic.setDottedSeries(null);
        this.logic.clearChart();
        this.logic.createCommons();
        this.logic.addAllCommonSeriesToTheChart();
        if (selected) {
            this.logic.getRemovalFiltersInUse().add(dataSetUserType);
        } else {
            this.logic.getRemovalFiltersInUse().remove(dataSetUserType);
        }
        this.logic.createHashesAndUpdate(false);
    }

    private void addResultMenu(long initialSampleLength, int defaultIndex) {
        JMenu resultMenu = new JMenu("Result");
        JMenu removalFiltersMenu = new JMenu("Removal filters");
        resultMenu.add(removalFiltersMenu);
        for (final DataSetUserType dataSetUserType : this.logic.getRemovalFilters()) {
            JCheckBox checkbox = new JCheckBox(dataSetUserType.getName());
            checkbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean selected = e.getStateChange() == 1;
                    ResultChart.this.toggleRemoveFilterCheckBox(dataSetUserType, selected);
                }
            });
            removalFiltersMenu.add(checkbox);
        }
        JMenu sampling = new JMenu("Sampling");
        JMenu graphType = new JMenu("Graph type");
        JRadioButtonMenuItem dots = new JRadioButtonMenuItem("Dots", false);
        JRadioButtonMenuItem lines = new JRadioButtonMenuItem("Samples", true);
        ButtonGroup graphTypeGroup = new ButtonGroup();
        graphTypeGroup.add(dots);
        graphTypeGroup.add(lines);
        graphType.add(dots);
        graphType.add(lines);
        resultMenu.add(graphType);
        dots.addActionListener(a -> this.ajustDottedMode(true));
        lines.addActionListener(a -> this.ajustDottedMode(false));
        JMenu sampleMethod = new JMenu("Sample method");
        JMenu sampleLengthMenu = new JMenu("Sample length");
        SteppingSlider slider = ResultChart.createSlider(initialSampleLength, this.logic.getMinorTickLength(), defaultIndex);
        slider.addChangeListener(e -> {
            JSlider source = (JSlider)e.getSource();
            if (!source.getValueIsAdjusting()) {
                int indexOfSlider = source.getValue();
                long newSampleLength = this.logic.calculateSampleLengthWith(indexOfSlider);
                this.chartSliderAjustment(newSampleLength);
            }
        });
        sampleLengthMenu.add(slider);
        sampling.add(sampleMethod);
        resultMenu.add(sampling);
        sampling.add(sampleLengthMenu);
        ButtonGroup group = new ButtonGroup();
        List<YCalculator> yCalculators = this.logic.getyCalculators();
        for (YCalculator calc : yCalculators) {
            JRadioButtonMenuItem sampleMethodMenuIten = new JRadioButtonMenuItem(calc.getName());
            group.add(sampleMethodMenuIten);
            sampleMethod.add(sampleMethodMenuIten);
            sampleMethodMenuIten.addActionListener(a -> {
                this.logic.clearChart();
                this.logic.addAllCommonSeriesToTheChart();
                this.logic.yCalculatorToUse = calc;
                this.logic.createHashesAndUpdate(false);
            });
        }
        this.chartFrame.getMenu().add(resultMenu);
    }

    protected static SteppingSlider createSlider(long initialSampleLength, int minorTickPacing, int defaultIndex) {
        int i;
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        ((Dictionary)labelTable).put(1, new JLabel("1"));
        int max = ChartUtils.calculateSampleLengthSliderMax(initialSampleLength);
        max = (int)initialSampleLength / 1000 + minorTickPacing * 4;
        ArrayList<Integer> valuesList = new ArrayList<Integer>();
        valuesList.add(1);
        for (i = minorTickPacing; i <= max; i += minorTickPacing) {
            if (valuesList.contains(i)) continue;
            valuesList.add(i);
        }
        for (i = 0; i < valuesList.size(); ++i) {
            ((Dictionary)labelTable).put(i, new JLabel("" + valuesList.get(i)));
        }
        Integer[] values = valuesList.toArray(new Integer[valuesList.size()]);
        SteppingSlider slider = new SteppingSlider(values, max, minorTickPacing, defaultIndex);
        slider.setLabelTable(labelTable);
        return slider;
    }

    void ajustDottedMode(boolean dottedMode) {
        this.logic.useDottedModeValue(dottedMode);
    }

    void chartSliderAjustment(long newSampleLength) {
        long sampleLengthToUse = newSampleLength;
        this.logic.setSampleLengthToUse(sampleLengthToUse);
        this.logic.createHashesAndUpdate(true);
    }
}

