/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.chart.common.CommonSampleGroup;
import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.FilteredData;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.load.chart.jfreechart.ChartFrame;
import com.loadcoder.load.chart.jfreechart.ItemSeriesAdder;
import com.loadcoder.load.chart.jfreechart.XYDottedSeriesExtension;
import com.loadcoder.load.chart.jfreechart.XYPlotExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesCollectionExtention;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.sampling.SampleGroup;
import com.loadcoder.load.chart.utilities.ChartUtils;
import com.loadcoder.load.chart.utilities.Utilities;
import com.loadcoder.load.jfreechartfixes.XYLineAndShapeRendererExtention;
import com.loadcoder.result.Result;
import com.loadcoder.result.TransactionExecutionResult;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultChartLogic
extends ChartLogic {
    static Logger log = LoggerFactory.getLogger(ResultChartLogic.class);
    private static final boolean allowDuplicateXValues_forDottedSeries = true;
    Result[] results;
    List<DataSetUserType> removalFilters = new ArrayList<DataSetUserType>();
    boolean dottedMode;
    List<List<TransactionExecutionResult>> originalFromFile = new ArrayList<List<TransactionExecutionResult>>();
    Map<Comparable, XYSeriesExtension> dottedSeries = null;
    Map<Comparable, XYSeriesExtension> series;
    final int minorTickLength;
    int defaultIndex;
    int sliderCompensation;
    protected static final int[][] sampleLengtSteps = new int[][]{{10, 1}, {10, 2}, {30, 5}, {100, 10}, {1000, 100}, {10000, 1000}, {100000, 10000}};
    static long[][] ticks = new long[][]{{600000L, 1L}, {1800000L, 2L}, {0x6DDD00L, 5L}, {14400000L, 10L}, {36000000L, 30L}, {86400000L, 60L}, {864000000L, 600L}, {Long.MAX_VALUE, 3600L}};

    public List<DataSetUserType> getRemovalFilters() {
        return this.removalFilters;
    }

    public void setDottedSeries(Map<Comparable, XYSeriesExtension> dottedSeries) {
        this.dottedSeries = dottedSeries;
    }

    public Map<Comparable, XYSeriesExtension> getDottedSeries() {
        return this.dottedSeries;
    }

    public ResultChartLogic(XYSeriesCollectionExtention seriesCollection, XYPlotExtension plot, XYLineAndShapeRendererExtention renderer, Map<Comparable, Boolean> seriesVisible, boolean defaultDottedMode, CommonSeries[] commonSeries, Map<Comparable, Color> customizedColors, boolean locked, Result ... results) {
        super(seriesCollection, plot, renderer, seriesVisible, locked);
        this.customizedColors = customizedColors;
        this.dottedMode = defaultDottedMode;
        this.results = results;
        this.commonsToBeUsed = commonSeries;
        this.populateRemovalFilters();
        this.populateResultLists(this.originalFromFile);
        this.originalFromFile = TransactionExecutionResult.mergeList(this.originalFromFile);
        this.filteredData = this.generateDataSets(this.originalFromFile);
        long tickSize = ResultChartLogic.calculateSliderTickSize(this.filteredData);
        this.minorTickLength = (int)tickSize;
        this.calculateSliderValueCompensation(this.minorTickLength);
        this.defaultIndex = 4;
        this.sampleLengthToUse = this.calculateSampleLengthWith(this.defaultIndex);
        ResultChartLogic.calculateDefaultIndex(this.sampleLengthToUse, this.minorTickLength);
        this.doSafeUpdate();
    }

    public long calculateSampleLengthWith(int indexOfSlider) {
        long newSampleLength = 1000L;
        if (indexOfSlider != 0) {
            long valueOfSlider = indexOfSlider * this.getMinorTickLength() + this.getsliderCompensation();
            newSampleLength = valueOfSlider * 1000L;
        }
        return newSampleLength;
    }

    public int getDefaultSliderIndex() {
        return this.defaultIndex;
    }

    public int getsliderCompensation() {
        return this.sliderCompensation;
    }

    void calculateSliderValueCompensation(int minorTickPacing) {
        int sliderCompensation = 0;
        if (minorTickPacing == 1) {
            sliderCompensation = 1;
        }
        this.sliderCompensation = sliderCompensation;
    }

    public int getMinorTickLength() {
        return this.minorTickLength;
    }

    @Override
    protected void doUpdate() {
        this.createHashesAndUpdate(true);
    }

    public void createHashesAndUpdate(boolean updateSamples) {
        HashSet<Long> hashesGettingUpdated = new HashSet<Long>();
        this.getDataAndUpdate(hashesGettingUpdated, updateSamples);
        this.forceRerender();
    }

    @Override
    protected void getDataAndUpdate(HashSet<Long> hashesGettingUpdated, boolean updateSamples) {
        this.update(this.originalFromFile, hashesGettingUpdated, updateSamples);
    }

    public void addSerieseToChart(Map<Comparable, XYSeriesExtension> seriesMap) {
        for (Comparable key : this.seriesKeys) {
            XYSeriesExtension series = seriesMap.get(key);
            this.sleep();
            this.addSeries(series);
        }
    }

    public void adjustVisibility(Map<Comparable, XYSeriesExtension> seriesMap) {
        for (Comparable key : this.seriesKeys) {
            XYSeriesExtension series = seriesMap.get(key);
            this.adjustVisibilityOfSeries(series);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void update(List<List<TransactionExecutionResult>> listOfListOfList, HashSet<Long> hashesGettingUpdated, boolean updateSamples) {
        this.seriesCollection.removeAllSeries();
        this.ranges.clear();
        this.earliestX = null;
        if (this.filteredData == null) {
            this.filteredData = this.generateDataSets(listOfListOfList);
        }
        this.addToSeriesKeys(this.filteredData, this.seriesKeys);
        HashSet<Long> sampleTimestamps = new HashSet<Long>();
        HashMap<Comparable, CommonSampleGroup> samplesCommonMap = new HashMap<Comparable, CommonSampleGroup>();
        ArrayList<CommonSampleGroup> sampleGroupCommonList = new ArrayList<CommonSampleGroup>();
        HashMap<Comparable, XYSeriesExtension> seriesMap = new HashMap();
        if (this.dottedMode) {
            if (this.dottedSeries == null) {
                this.dottedSeries = this.createDottedSeries(this.filteredData.getDataSets());
            }
            seriesMap = this.dottedSeries;
        } else {
            this.getSerieses(this.filteredData.getDataSets(), this.dottedMode, seriesMap);
        }
        HashMap<Comparable, SampleGroup> sampleGroups = new HashMap<Comparable, SampleGroup>();
        this.createSamplesGroups(seriesMap, sampleGroups);
        this.addSerieseToChart(seriesMap);
        this.adjustVisibility(seriesMap);
        this.createCommons();
        this.addAllCommonSeriesToTheChart();
        for (XYSeriesExtension commonSerie : this.commonSeries) {
            this.adjustVisibilityOfSeries(commonSerie);
        }
        this.addPoints(this.filteredData.getDataSets(), sampleGroups, sampleTimestamps);
        ItemSeriesAdder itemSeriesAdderToUse = ChartUtils.itemSeriesAdderForSamples;
        if (this.dottedMode) {
            itemSeriesAdderToUse = ChartUtils.itemSeriesAdderForDots;
            if (this.dottedSeries == null) {
                this.createDottedSeries(this.filteredData.getDataSets());
            } else {
                this.populateChartWithSavedDottedSeries();
            }
        }
        this.updateSeriesWithSamples(itemSeriesAdderToUse, hashesGettingUpdated, this.filteredData.getDataSets(), sampleGroups, sampleTimestamps);
        this.updateCommonsWithSamples(hashesGettingUpdated, sampleGroups, samplesCommonMap, sampleGroupCommonList);
    }

    protected FilteredData generateDataSets(List<List<TransactionExecutionResult>> src) {
        ArrayList<List<TransactionExecutionResult>> inputToChart = new ArrayList<List<TransactionExecutionResult>>();
        this.cloneTheOriginalResultList(inputToChart, src);
        long[] minmax = Utilities.findMinMaxTimestamp(inputToChart);
        long[] minmaxPoints = new long[]{0L, minmax[1] - minmax[0]};
        List<DataSet> generated = Utilities.convert(inputToChart, minmax[0], true);
        for (DataSetUserType type : this.removalFiltersInUse) {
            type.getDataSetUser().useDataSet(generated);
        }
        return new FilteredData(generated, minmax, minmaxPoints);
    }

    public void populateRemovalFilters() {
        this.removalFilters.add(DataSetUserType.PERCENTREMOVALFILTER);
        this.removalFilters.add(DataSetUserType.FAILSREMOVALFILTER);
    }

    public void useDottedModeValue(boolean dottedMode) {
        if (this.dottedMode == dottedMode) {
            return;
        }
        this.dottedMode = dottedMode;
        this.createHashesAndUpdate(false);
    }

    protected void populateResultLists(List<List<TransactionExecutionResult>> listOfListOfList) {
        for (Result r : this.results) {
            this.useResult(r, listOfListOfList);
        }
    }

    public static ChartFrame.DataSetUser removeFails() {
        ChartFrame.DataSetUser percentile = a -> {
            for (DataSet dataSet : a) {
                for (Point p : dataSet.getPoints()) {
                    if (p.isStatus()) continue;
                    p.setEnabled(false);
                }
            }
        };
        return percentile;
    }

    public static ChartFrame.DataSetUser removePercentile(int percentilToRemove) {
        ChartFrame.DataSetUser percentile = a -> {
            for (DataSet dataSet : a) {
                dataSet.getPoints().sort((b, c) -> {
                    long diff = c.getY() - b.getY();
                    return (int)diff;
                });
                double factor = (double)percentilToRemove / 100.0;
                int index = (int)((double)dataSet.getPoints().size() * factor);
                for (int i = 0; i < index; ++i) {
                    dataSet.getPoints().get(i).setEnabled(false);
                }
            }
        };
        return percentile;
    }

    public static double amountOfSeriesesFactor(int amountOfThreads) {
        double factor = 1.0 + Math.log(1.0 + (double)amountOfThreads * 0.1);
        return factor;
    }

    public static int calculateDefaultIndex(long sampleLengthToUse, int minorTickLength) {
        int initalSlideValue = (int)(sampleLengthToUse / 1000L);
        int defaultIndex = initalSlideValue / minorTickLength;
        return defaultIndex;
    }

    public static long calculateSliderTickSize(FilteredData filteredData) {
        long[] minmax = filteredData.getMinmax();
        long diff = minmax[1] - minmax[0];
        for (long[] tick : ticks) {
            if (diff >= tick[0]) continue;
            return tick[1];
        }
        log.error("Internal error in class {} when calculating tick size for samplelength slider", ResultChartLogic.class);
        return 3600L;
    }

    public static long calculateSampleLengthDefault(FilteredData filteredData) {
        long[] minmax = filteredData.getMinmax();
        int amoutOfTransactionTypes = filteredData.getDataSets().size();
        return ResultChartLogic.calculateSampleLengthDefault(minmax[0], minmax[1], amoutOfTransactionTypes);
    }

    public static long calculateSampleLengthDefault(long min, long max, int amountOfTransactionTypes) {
        long diff = max - min;
        if (diff < 0L) {
            throw new RuntimeException("Internal error. The earliest timestamp must be lower than the lastest timestamp");
        }
        int targetAmountOfSamplesForOneSeries = 1000;
        long diffPerSample = diff / (long)targetAmountOfSamplesForOneSeries;
        double amountOfSeriesesFactor = ResultChartLogic.amountOfSeriesesFactor(amountOfTransactionTypes);
        long diffPerSampleForAllSeries = (long)((double)diffPerSample * amountOfSeriesesFactor);
        long sampleLengthInSeconds = diffPerSampleForAllSeries / 1000L;
        long sampleLengthInMillis = sampleLengthInSeconds * 1000L;
        if (sampleLengthInMillis < 1000L) {
            sampleLengthInMillis = 1000L;
        }
        return sampleLengthInMillis;
    }

    public void cloneTheOriginalResultList(List<List<TransactionExecutionResult>> dst, List<List<TransactionExecutionResult>> original) {
        for (List<TransactionExecutionResult> list : original) {
            ArrayList casted = (ArrayList)list;
            ArrayList clone = (ArrayList)casted.clone();
            dst.add(clone);
        }
    }

    public void clearChart() {
        this.commonSeriesCalculators.clear();
        this.seriesCollection.removeAllSeries();
        this.plot.getLegends();
        this.ranges.clear();
        this.earliestX = null;
    }

    void populateChartWithSavedDottedSeries() {
        for (Comparable key : this.seriesKeys) {
            XYSeriesExtension series = this.dottedSeries.get(key);
            int indexOfSeries = this.seriesCollection.indexOf(series);
            Boolean visible = (Boolean)this.seriesVisible.get(series.getKey());
            if (visible == null || visible.booleanValue()) {
                this.renderer.setSeriesShapesVisible(indexOfSeries, true);
            } else {
                this.renderer.setSeriesShapesVisible(indexOfSeries, false);
            }
            this.renderer.setSeriesLinesVisible(indexOfSeries, false);
        }
    }

    Map<Comparable, XYSeriesExtension> createDottedSeries(List<DataSet> dataSets) {
        HashMap<Comparable, XYSeriesExtension> result = new HashMap<Comparable, XYSeriesExtension>();
        for (DataSet dataSet : dataSets) {
            String dataSetName = dataSet.getName();
            Paint seriesColor = this.getSeriesColor((Comparable)((Object)dataSetName));
            XYDottedSeriesExtension serie = new XYDottedSeriesExtension((Comparable)((Object)dataSetName), true, true, seriesColor);
            result.put((Comparable)((Object)dataSetName), serie);
        }
        return result;
    }
}

