/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.sampling;

import com.loadcoder.load.chart.common.YCalculator;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.load.chart.data.Range;
import com.loadcoder.load.chart.jfreechart.XYDataItemExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.sampling.Group;
import com.loadcoder.load.chart.sampling.Sample;
import com.loadcoder.load.chart.sampling.SampleConcaternator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleGroup
extends Group {
    boolean locked = true;
    long startOfTheGroup = 0L;
    long sampleLengthBase = 0L;
    Sample earliestSample;
    private Map<Long, Sample> samples = new HashMap<Long, Sample>();
    private Map<Long, Sample> samplesUnupdated = new HashMap<Long, Sample>();
    YCalculator yCalculatorToUse = YCalculator.avg;

    public SampleGroup(long sampleLength, XYSeriesExtension series, boolean locked) {
        this.locked = locked;
        this.sampleLengthBase = sampleLength;
        this.series = series;
    }

    public String toString() {
        return String.format("{samples:%s, samplesUnupdated:%s}", this.samples.size(), this.samplesUnupdated.size());
    }

    public Sample getEarliestSample() {
        return this.earliestSample;
    }

    protected Map<Long, Sample> getSamples() {
        return this.samples;
    }

    public Map<Long, Sample> getSamplesUnupdated() {
        return this.samplesUnupdated;
    }

    public void remove(Sample s) {
        this.samples.remove(s.getFirstTs());
    }

    public ConcaternationResult concaternate(SampleConcaternator concater) {
        long start = concater.getOldRange().getStart();
        Range oldRange = concater.getOldRange();
        long oldSampleLength = oldRange.getSampleLength();
        int amountToConcaternate = concater.getAmountToConcaternate();
        long tsIterator = start;
        ArrayList<Point> newPoints = new ArrayList<Point>();
        int newAmountOfFails = 0;
        long pointsSum = 0L;
        long pointsAmount = 0L;
        ArrayList<Sample> concaternated = new ArrayList<Sample>();
        for (int i = 0; i < amountToConcaternate; ++i) {
            Sample toBeConcaternated = this.getExistingSample(tsIterator, oldSampleLength);
            if (toBeConcaternated != null) {
                concaternated.add(toBeConcaternated);
                newAmountOfFails += toBeConcaternated.getAmountOfFails();
                this.remove(toBeConcaternated);
                pointsSum += toBeConcaternated.getPointsSum();
                pointsAmount += toBeConcaternated.getAmountOfPoints();
                newPoints.addAll(toBeConcaternated.scrapThisSampleAndGetPoints());
            }
            tsIterator += oldSampleLength;
        }
        Range newRange = concater.getNewRange();
        long newSampleLength = newRange.getSampleLength();
        Sample newSample = this.createSample(start, (Comparable)((Object)""), newSampleLength);
        newSample.setFails(newAmountOfFails);
        newSample.setPoints(newPoints);
        newSample.setPointsSum(pointsSum);
        newSample.setPointsAmount(pointsAmount);
        if (!newSample.isEmpty()) {
            newSample.calculateY(this.yCalculatorToUse);
        }
        ConcaternationResult concaternationResult = new ConcaternationResult(concaternated, newSample);
        return concaternationResult;
    }

    private Sample createSample(long first, Comparable name) {
        return this.createSample(first, name, this.sampleLengthBase);
    }

    private Sample createSample(long first, Comparable name, long sampleLength) {
        long nextFirst;
        Sample nextSample;
        Sample s = new Sample(first, sampleLength, name, this.locked);
        this.samples.put(first, s);
        long previousFirst = first - sampleLength;
        Sample previousSample = this.samples.get(previousFirst);
        if (previousSample != null) {
            s.setPreviousSample(previousSample);
        }
        if ((nextSample = this.samples.get(nextFirst = first + sampleLength)) != null) {
            nextSample.setPreviousSample(s);
        }
        return s;
    }

    public Sample getAndCreateSample_old(long ts, Comparable name, long sampleLength) {
        long first = SampleGroup.calculateFirstTs(ts, sampleLength);
        Sample s = this.samples.get(first);
        if (s == null) {
            s = this.createSample(first, name);
        }
        return s;
    }

    public Sample getAndCreateSample(long ts, Comparable name, long sampleLength) {
        long first = SampleGroup.calculateFirstTs(ts, sampleLength);
        Sample s = this.samples.get(first);
        if (s == null) {
            s = this.createSample(first, name);
        }
        return s;
    }

    public Sample getExistingSample(long ts, long sampleLength) {
        long first = SampleGroup.calculateFirstTs(ts, sampleLength);
        Sample s = this.samples.get(first);
        return s;
    }

    public Sample getExistingAndRemoveSample(long ts, long sampleLength) {
        long first = SampleGroup.calculateFirstTs(ts, sampleLength);
        Sample s = this.samples.remove(first);
        return s;
    }

    public static class ConcaternationResult {
        List<Sample> concaternated;
        Sample newSample;

        ConcaternationResult(List<Sample> concaternated, Sample newSample) {
            this.concaternated = concaternated;
            this.newSample = newSample;
        }

        public List<Sample> getConcatenated() {
            return this.concaternated;
        }

        public void fixPointsForSeries(XYSeriesExtension series) {
            for (Sample toBeConcaternated : this.concaternated) {
                XYDataItemExtension first = toBeConcaternated.getFirst();
                if (first == null) continue;
                series.remove(first.getX());
            }
            if (!this.newSample.isEmpty()) {
                this.newSample.initDataItems();
                XYDataItemExtension first = this.newSample.getFirst();
                series.add(first, false, true);
            }
        }
    }
}

