/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.utilities;

import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.result.TransactionExecutionResult;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;

public class Utilities {
    public static long[] findMinMaxTimestamp(List<List<TransactionExecutionResult>> resultLists) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (List<TransactionExecutionResult> resultList : resultLists) {
            for (TransactionExecutionResult result : resultList) {
                if (result.getTs() < min) {
                    min = result.getTs();
                }
                if (result.getTs() <= max) continue;
                max = result.getTs();
            }
        }
        return new long[]{min, max};
    }

    public static List<DataSet> convert(List<List<TransactionExecutionResult>> resultLists, long earliestTs, boolean convertToRelativeTime) {
        return Utilities.convert(resultLists, earliestTs, convertToRelativeTime, null);
    }

    public static List<DataSet> convert(List<List<TransactionExecutionResult>> resultLists, long earliestTs, boolean convertToRelativeTime, JTextArea message) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        if (resultLists.isEmpty()) {
            return dataSets;
        }
        for (List<TransactionExecutionResult> resultList : resultLists) {
            TransactionExecutionResult firstResult = resultList.get(0);
            DataSet dataSet = new DataSet(firstResult.getName(), new ArrayList<Point>());
            dataSets.add(dataSet);
            for (TransactionExecutionResult result : resultList) {
                if (convertToRelativeTime) {
                    dataSet.getPoints().add(new Point(result.getTs() - earliestTs, result.getRt(), result.isStatus()));
                    continue;
                }
                dataSet.getPoints().add(new Point(result.getTs(), result.getRt(), result.isStatus()));
            }
        }
        return dataSets;
    }
}

