/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.common;

import com.loadcoder.load.chart.common.CommonSample;
import com.loadcoder.load.chart.data.Range;
import com.loadcoder.load.chart.jfreechart.XYDataItemExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.sampling.Group;
import com.loadcoder.load.chart.sampling.SampleConcaternator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSampleGroup
extends Group {
    Logger log = LoggerFactory.getLogger(ChartLogic.class);
    XYSeriesExtension series;
    Map<Long, CommonSample> commonSamples = new HashMap<Long, CommonSample>();

    public CommonSampleGroup(XYSeriesExtension series) {
        this.series = series;
    }

    public void removeAllOldSamples(long start, int amountToConcaternate, long oldSampleLength) {
        long tsIterator = start;
        for (int i = 0; i < amountToConcaternate; ++i) {
            long firstTs = CommonSampleGroup.calculateFirstTs(tsIterator, oldSampleLength);
            CommonSample toBeConcaternated = this.commonSamples.get(firstTs);
            if (toBeConcaternated != null) {
                XYDataItemExtension first = toBeConcaternated.getFirst();
                if (first != null) {
                    this.series.remove(first.getX());
                    if (this.series.getKey().contains("Throughput")) {
                        this.log.trace("removing Throughput at x:{} y:{}", (Object)first.getX().intValue(), (Object)first.getY().intValue());
                    }
                }
                this.commonSamples.remove(toBeConcaternated.getFirstTs());
            }
            tsIterator += oldSampleLength;
        }
    }

    public void concaternate(SampleConcaternator concater) {
        Range oldRange = concater.getOldRange();
        long start = oldRange.getStart();
        long oldSampleLength = oldRange.getSampleLength();
        int amountToConcaternate = concater.getAmountToConcaternate();
        this.removeAllOldSamples(start, amountToConcaternate, oldSampleLength);
        Range newRange = concater.getNewRange();
        long newSampleLength = newRange.getSampleLength();
        this.createCommonSampleAndPutInMap(start, newSampleLength);
    }

    public void putCommonSample(Long key, CommonSample commonSample) {
        this.commonSamples.put(key, commonSample);
    }

    public CommonSample getAndCreateSampleAndPutInMap(long ts, long sampleLength) {
        long first = CommonSampleGroup.calculateFirstTs(ts, sampleLength);
        CommonSample s = this.getSample(first, sampleLength);
        if (s == null) {
            s = this.createCommonSampleAndPutInMap(first, sampleLength);
        }
        return s;
    }

    public CommonSample getSample(long first, long sampleLength) {
        CommonSample s = this.fetch(first, sampleLength);
        return s;
    }

    protected CommonSample fetch(long firstTs, long sampleLength) {
        CommonSample s = this.commonSamples.get(firstTs);
        return s;
    }

    private CommonSample createCommonSampleAndPutInMap(long first, long sampleLength) {
        CommonSample s = new CommonSample(first, sampleLength);
        this.commonSamples.put(first, s);
        return s;
    }
}

