/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.common;

import com.loadcoder.load.chart.common.CommonYCalculator;
import com.loadcoder.load.chart.sampling.Sample;
import com.loadcoder.load.chart.sampling.SampleGroup;

public class CommonYCalculators {
    public static final CommonYCalculator THROUGHPUT = (keys, timestamp, sampleGroups, sampleLength) -> {
        double amount = 0.0;
        for (String key : keys) {
            SampleGroup group = (SampleGroup)sampleGroups.get(key);
            Sample s = group.getExistingSample(timestamp, sampleLength);
            amount += s == null ? 0.0 : (double)s.getAmountOfPoints();
        }
        double pointsPerSecond = amount / (double)(sampleLength / 1000L);
        return pointsPerSecond;
    };
    public static final CommonYCalculator FAILS = (keys, timestamp, sampleGroups, sampleLength) -> {
        double amount = 0.0;
        for (String key : keys) {
            SampleGroup group = (SampleGroup)sampleGroups.get(key);
            Sample s = group.getExistingSample(timestamp, sampleLength);
            if (s == null) continue;
            int amountOfPoints = s.getAmountOfFails();
            amount += (double)amountOfPoints;
        }
        return amount /= (double)(sampleLength / 1000L);
    };
}

