/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.data;

import com.loadcoder.load.chart.data.Range;
import java.util.ArrayList;
import java.util.List;

public class Ranges {
    private final List<Range> ranges = new ArrayList<Range>();

    public void clearRanges() {
        this.ranges.clear();
    }

    public void addRange(Range range) {
        this.ranges.add(range);
    }

    public Range getRange(int index) {
        return this.ranges.get(index);
    }

    public Range getLastRange() {
        return this.ranges.get(this.ranges.size() - 1);
    }

    public boolean isRangesEmpty() {
        return this.ranges.isEmpty();
    }

    public Range lookupCorrectRange(long ts) {
        for (Range range : this.ranges) {
            if (!range.isTimestampInThisRange(ts)) continue;
            return range;
        }
        return null;
    }

    public long findSampleLength(long timeStamp) {
        for (Range range : this.ranges) {
            if (range.getStart() > timeStamp || range.getEnd() < timeStamp) continue;
            return range.getSampleLength();
        }
        throw new RuntimeException("no matching range found. This should never happend!");
    }
}

