/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.chart.common.CommonSampleGroup;
import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.FilteredData;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.load.chart.jfreechart.ChartFrame;
import com.loadcoder.load.chart.jfreechart.XYDottedSeriesExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.menu.SteppingSlider;
import com.loadcoder.load.chart.sampling.SampleGroup;
import com.loadcoder.load.chart.utilities.ChartUtils;
import com.loadcoder.load.chart.utilities.Utilities;
import com.loadcoder.result.Result;
import com.loadcoder.result.TransactionExecutionResult;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultChartLogic
extends ChartLogic {
    private static Logger logger = LoggerFactory.getLogger(ResultChartLogic.class);
    private static final boolean ALLOW_DUPLICATE_X_VALUES_FOR_POINT_SERIES = true;
    private List<DataSetUserType> removalFilters = new ArrayList<DataSetUserType>();
    private boolean dottedMode;
    private final Map<String, List<TransactionExecutionResult>> originalFromFile;
    private Map<String, XYSeriesExtension> dottedSeries = null;
    private double keepFactorChosen = -1.0;
    private JRadioButtonMenuItem pointsRadioButton;
    private long newSampleLengthSelection = -1L;
    private SteppingSlider sampleLengthSlider;
    double keepFactorDefault = -1.0;
    final int minorTickLength;
    int defaultIndex;
    int sliderCompensation;
    static long[][] ticks = new long[][]{{600000L, 1L}, {1800000L, 2L}, {0x6DDD00L, 5L}, {14400000L, 10L}, {36000000L, 30L}, {86400000L, 60L}, {864000000L, 600L}, {Long.MAX_VALUE, 3600L}};

    public void setNewSampleLengthSelection(long newSampleLengthSelection) {
        this.newSampleLengthSelection = newSampleLengthSelection;
    }

    public long getNewSampleLengthSelection() {
        return this.newSampleLengthSelection;
    }

    public SteppingSlider getSteppingSlider() {
        return this.sampleLengthSlider;
    }

    protected static List<Integer> getValuesForSliderAsList(long currentSampleLength, int tickPacing) {
        int valueWith4TicksBiggerThanCurrentSampleLengthTickValue = (int)currentSampleLength / 1000 + tickPacing * 4;
        ArrayList<Integer> valuesList = new ArrayList<Integer>();
        valuesList.add(1);
        for (int i = tickPacing; i <= valueWith4TicksBiggerThanCurrentSampleLengthTickValue; i += tickPacing) {
            if (valuesList.contains(i)) continue;
            valuesList.add(i);
        }
        return valuesList;
    }

    protected SteppingSlider createSlider(long initialSampleLength, int minorTickPacing, int defaultIndex) {
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        List<Integer> valuesList = ResultChartLogic.getValuesForSliderAsList(initialSampleLength, minorTickPacing);
        for (int i = 0; i < valuesList.size(); ++i) {
            ((Dictionary)labelTable).put(i, new JLabel("" + valuesList.get(i)));
        }
        Integer[] values = valuesList.toArray(new Integer[valuesList.size()]);
        SteppingSlider slider = new SteppingSlider(values, defaultIndex);
        slider.setLabelTable(labelTable);
        slider.addChangeListener(e -> {
            JSlider source = (JSlider)e.getSource();
            if (!source.getValueIsAdjusting()) {
                int indexOfSlider = source.getValue();
                long newSampleLength = this.calculateSampleLengthWith(indexOfSlider);
                this.setNewSampleLengthSelection(newSampleLength);
            }
        });
        return slider;
    }

    public double getCurrentKeepFactor() {
        if (this.getKeepFactorChosen() != -1.0) {
            return this.getKeepFactorChosen();
        }
        return this.getKeepFactorDefault();
    }

    public JRadioButtonMenuItem getPointsRadioButton() {
        return this.pointsRadioButton;
    }

    public void setPointsRadioButton(JRadioButtonMenuItem pointsRadioButton) {
        this.pointsRadioButton = pointsRadioButton;
    }

    public double getKeepFactorChosen() {
        return this.keepFactorChosen;
    }

    public double getKeepFactorDefault() {
        return this.keepFactorDefault;
    }

    public void setKeepFactorChosen(double keepFactorChosen) {
        this.keepFactorChosen = keepFactorChosen;
    }

    public List<DataSetUserType> getRemovalFilters() {
        return this.removalFilters;
    }

    public void setDottedSeries(Map<String, XYSeriesExtension> dottedSeries) {
        this.dottedSeries = dottedSeries;
    }

    public Map<String, XYSeriesExtension> getDottedSeries() {
        return this.dottedSeries;
    }

    public ResultChartLogic(boolean defaultDottedMode, CommonSeries[] commonSeries, boolean locked, Result ... results) {
        super(commonSeries, locked);
        this.dottedMode = defaultDottedMode;
        this.populateRemovalFilters();
        this.originalFromFile = this.populateResultLists(results);
        this.originalFromFile.keySet().stream().forEach(key -> this.addSeriesKey((String)key));
        this.setFilteredData(this.generateDataSets(this.originalFromFile));
        int totalAmountOfPoints = 0;
        if (this.keepFactorDefault == -1.0) {
            for (DataSet set : this.getFilteredData().getDataSets()) {
                totalAmountOfPoints += set.getPoints().size();
            }
            this.keepFactorDefault = ChartUtils.calculateKeepFactor(totalAmountOfPoints, 20000);
        }
        long tickSize = ResultChartLogic.calculateSliderTickSize(this.getFilteredData());
        this.minorTickLength = (int)tickSize;
        this.calculateSliderValueCompensation(this.minorTickLength);
        this.defaultIndex = 4;
        int minorTickLengthInAmountOfSeconds = this.getMinorTickLength();
        if (minorTickLengthInAmountOfSeconds <= 4) {
            this.defaultIndex = minorTickLengthInAmountOfSeconds - 1;
        }
        this.sampleLengthSlider = this.createSlider(this.getSampleLengthToUse(), this.getMinorTickLength(), this.getDefaultSliderIndex());
        long sampleLength = this.calculateSampleLengthWith(this.defaultIndex);
        this.setSampleLengthToUse(sampleLength);
        this.initiateChart();
        this.doSafeUpdate();
    }

    @Override
    protected void update(Map<String, List<TransactionExecutionResult>> listOfListOfList, HashSet<Long> hashesGettingUpdated) {
        this.seriesCollection.removeAllSeries();
        this.ranges.clearRanges();
        this.commonSeriesCalculators.clear();
        this.initCommonSeries();
        this.handleData(listOfListOfList, hashesGettingUpdated);
    }

    private void handleData(Map<String, List<TransactionExecutionResult>> listOfListOfList, HashSet<Long> hashesGettingUpdated) {
        this.earliestX = null;
        FilteredData filteredData = this.getFilteredData();
        if (filteredData == null) {
            filteredData = this.generateDataSets(listOfListOfList);
            this.setFilteredData(filteredData);
        }
        HashSet<Long> sampleTimestamps = new HashSet<Long>();
        HashMap<String, CommonSampleGroup> samplesCommonMap = new HashMap<String, CommonSampleGroup>();
        ArrayList<CommonSampleGroup> sampleGroupCommonList = new ArrayList<CommonSampleGroup>();
        Map<String, XYSeriesExtension> seriesMap = new HashMap<String, XYSeriesExtension>();
        if (this.dottedMode) {
            if (this.dottedSeries == null) {
                this.setDottedSeries(this.createDottedSeries(filteredData.getDataSets()));
            }
            seriesMap = this.dottedSeries;
        } else {
            this.getSerieses(filteredData.getDataSets(), seriesMap);
        }
        HashMap<String, SampleGroup> sampleGroups = new HashMap<String, SampleGroup>();
        this.createSamplesGroups(seriesMap, sampleGroups);
        this.addSerieseToChart(seriesMap);
        this.adjustVisibility(seriesMap);
        for (XYSeriesExtension commonSerie : this.getCommonSeriesMap().values()) {
            this.adjustVisibilityOfSeries(commonSerie);
        }
        this.addPoints(filteredData.getDataSets(), sampleGroups, sampleTimestamps);
        if (this.dottedMode) {
            if (this.dottedSeries == null) {
                this.createDottedSeries(filteredData.getDataSets());
            } else {
                this.populateChartWithSavedDottedSeries();
            }
        }
        if (this.dottedMode) {
            double keepFactor = this.keepFactorChosen == -1.0 ? this.keepFactorDefault : this.keepFactorChosen;
            for (DataSet set : filteredData.getDataSets()) {
                SampleGroup group = (SampleGroup)sampleGroups.get(set.getName());
                XYSeriesExtension series = group.getSeries();
                ChartUtils.populateSeriesWithPoints(set.getPoints(), series, keepFactor);
            }
        }
        this.updateSeriesWithSamples(hashesGettingUpdated, filteredData.getDataSets(), sampleGroups, sampleTimestamps, this.dottedMode);
        this.updateCommonsWithSamples(hashesGettingUpdated, sampleGroups, samplesCommonMap, sampleGroupCommonList);
    }

    public long calculateSampleLengthWith(int indexOfSlider) {
        long newSampleLength = 1000L;
        if (indexOfSlider != 0) {
            long valueOfSlider = indexOfSlider * this.minorTickLength + this.sliderCompensation;
            newSampleLength = valueOfSlider * 1000L;
        }
        return newSampleLength;
    }

    public int getDefaultSliderIndex() {
        return this.defaultIndex;
    }

    public int getsliderCompensation() {
        return this.sliderCompensation;
    }

    void calculateSliderValueCompensation(int minorTickPacing) {
        int sliderCompensation = 0;
        if (minorTickPacing == 1) {
            sliderCompensation = 1;
        }
        this.sliderCompensation = sliderCompensation;
    }

    public void chartSliderAjustment(long newSampleLength) {
        long sampleLengthToUse = newSampleLength;
        this.setSampleLengthToUse(sampleLengthToUse);
        this.clearChart();
        this.createHashesAndUpdate(true);
    }

    public int getMinorTickLength() {
        return this.minorTickLength;
    }

    @Override
    protected void doUpdate() {
        this.createHashesAndUpdate(true);
    }

    public void recreateDottedSeries() {
        this.setFilteredData(null);
        this.setDottedSeries(null);
        this.clearChart();
        this.getCommonSeriesMap().clear();
        this.createCommons();
        this.addAllCommonSeriesToTheChart();
        this.createHashesAndUpdate(false);
    }

    public void createHashesAndUpdate(boolean updateSamples) {
        HashSet<Long> hashesGettingUpdated = new HashSet<Long>();
        long start = System.currentTimeMillis();
        this.update(this.originalFromFile, hashesGettingUpdated);
        long diff = System.currentTimeMillis() - start;
        logger.debug("update time: {}", (Object)diff);
        this.forceRerender();
    }

    public void addSerieseToChart(Map<String, XYSeriesExtension> seriesMap) {
        for (String key : this.getSeriesKeys()) {
            XYSeriesExtension series = seriesMap.get(key);
            this.addSeries(series);
        }
    }

    public void adjustVisibility(Map<String, XYSeriesExtension> seriesMap) {
        for (String key : this.getSeriesKeys()) {
            XYSeriesExtension series = seriesMap.get(key);
            this.adjustVisibilityOfSeries(series);
        }
    }

    void setCorrectColorsForDottedSerieses(Map<String, XYSeriesExtension> dottedSerieses) {
        dottedSerieses.entrySet().stream().forEach(entry -> {
            XYSeriesExtension dottedSeries = (XYSeriesExtension)((Object)((Object)entry.getValue()));
            String dataSetName = dottedSeries.getKey();
            Paint seriesColor = this.getSeriesColor(dataSetName);
        });
    }

    protected FilteredData generateDataSets(Map<String, List<TransactionExecutionResult>> src) {
        Map<String, List<TransactionExecutionResult>> inputToChart = this.cloneTheOriginalResultList(src);
        long[] minmax = Utilities.findMinMaxTimestamp(inputToChart, this.getSeriesKeys());
        long[] minmaxPoints = new long[]{0L, minmax[1] - minmax[0]};
        List<DataSet> generated = Utilities.convert(inputToChart, minmax[0], true, this.getSeriesKeys());
        for (DataSetUserType type : this.getRemovalFiltersInUse()) {
            type.getDataSetUser().useDataSet(generated);
        }
        return new FilteredData(generated, minmax, minmaxPoints);
    }

    public void populateRemovalFilters() {
        this.removalFilters.add(DataSetUserType.PERCENTREMOVALFILTER);
        this.removalFilters.add(DataSetUserType.FAILSREMOVALFILTER);
    }

    public void useDottedModeValue(boolean dottedMode) {
        if (this.dottedMode == dottedMode) {
            return;
        }
        this.dottedMode = dottedMode;
        this.createHashesAndUpdate(false);
    }

    protected Map<String, List<TransactionExecutionResult>> populateResultLists(Result ... results) {
        HashMap<String, List<TransactionExecutionResult>> listOfListOfTransactionResults = new HashMap<String, List<TransactionExecutionResult>>();
        for (Result r : results) {
            this.useResult(r, listOfListOfTransactionResults);
        }
        return listOfListOfTransactionResults;
    }

    protected void useResult(Result r, Map<String, List<TransactionExecutionResult>> listOfListOfTransactionResults) {
        Map transactionExecutionResults = r.getResultLists();
        for (String key : transactionExecutionResults.keySet()) {
            List listToBeCopiedAndCleared = (List)transactionExecutionResults.get(key);
            List<TransactionExecutionResult> newList = listOfListOfTransactionResults.get(key);
            if (newList == null) {
                newList = new ArrayList<TransactionExecutionResult>();
                listOfListOfTransactionResults.put(key, newList);
            }
            newList.addAll(listToBeCopiedAndCleared);
        }
    }

    public static ChartFrame.DataSetUser removeFails() {
        ChartFrame.DataSetUser percentile = a -> {
            for (DataSet dataSet : a) {
                for (Point p : dataSet.getPoints()) {
                    if (p.isStatus()) continue;
                    p.setEnabled(false);
                }
            }
        };
        return percentile;
    }

    public static ChartFrame.DataSetUser removePercentile(int percentilToRemove) {
        ChartFrame.DataSetUser percentile = a -> {
            for (DataSet dataSet : a) {
                dataSet.getPoints().sort((b, c) -> {
                    long diff = c.getY() - b.getY();
                    return (int)diff;
                });
                double factor = (double)percentilToRemove / 100.0;
                int index = (int)((double)dataSet.getPoints().size() * factor);
                for (int i = 0; i < index; ++i) {
                    dataSet.getPoints().get(i).setEnabled(false);
                }
            }
        };
        return percentile;
    }

    protected static double amountOfSeriesesFactor(int amountOfThreads) {
        double factor = 1.0 + Math.log(1.0 + (double)amountOfThreads * 0.1);
        return factor;
    }

    public static int calculateDefaultIndex(long sampleLengthToUse, int minorTickLength) {
        int initalSlideValue = (int)(sampleLengthToUse / 1000L);
        int defaultIndex = initalSlideValue / minorTickLength;
        return defaultIndex;
    }

    public static long calculateSliderTickSize(FilteredData filteredData) {
        long[] minmax = filteredData.getMinmax();
        long diff = minmax[1] - minmax[0];
        for (long[] tick : ticks) {
            if (diff >= tick[0]) continue;
            return tick[1];
        }
        logger.error("Internal error in class {} when calculating tick size for samplelength slider", ResultChartLogic.class);
        return 3600L;
    }

    public static long calculateSampleLengthDefault(FilteredData filteredData) {
        long[] minmax = filteredData.getMinmax();
        int amoutOfTransactionTypes = filteredData.getDataSets().size();
        return ResultChartLogic.calculateSampleLengthDefault(minmax[0], minmax[1], amoutOfTransactionTypes);
    }

    public static long calculateSampleLengthDefault(long min, long max, int amountOfTransactionTypes) {
        long diff = max - min;
        if (diff < 0L) {
            throw new RuntimeException("Internal error. The earliest timestamp must be lower than the lastest timestamp");
        }
        int targetAmountOfSamplesForOneSeries = 1000;
        long diffPerSample = diff / (long)targetAmountOfSamplesForOneSeries;
        double amountOfSeriesesFactor = ResultChartLogic.amountOfSeriesesFactor(amountOfTransactionTypes);
        long diffPerSampleForAllSeries = (long)((double)diffPerSample * amountOfSeriesesFactor);
        long sampleLengthInSeconds = diffPerSampleForAllSeries / 1000L;
        long sampleLengthInMillis = sampleLengthInSeconds * 1000L;
        if (sampleLengthInMillis < 1000L) {
            sampleLengthInMillis = 1000L;
        }
        return sampleLengthInMillis;
    }

    public Map<String, List<TransactionExecutionResult>> cloneTheOriginalResultList(Map<String, List<TransactionExecutionResult>> original) {
        HashMap<String, List<TransactionExecutionResult>> dst = new HashMap<String, List<TransactionExecutionResult>>();
        for (String key : this.getSeriesKeys()) {
            List<TransactionExecutionResult> list = original.get(key);
            ArrayList casted = (ArrayList)list;
            ArrayList clone = (ArrayList)casted.clone();
            dst.put(key, clone);
        }
        return dst;
    }

    public void clearChart() {
        this.commonSeriesCalculators.clear();
        this.seriesCollection.removeAllSeries();
        this.ranges.clearRanges();
        this.earliestX = null;
    }

    void populateChartWithSavedDottedSeries() {
        for (String key : this.getSeriesKeys()) {
            XYSeriesExtension series = this.dottedSeries.get(key);
            int indexOfSeries = this.seriesCollection.indexOf(series);
            Boolean visible = (Boolean)this.seriesVisible.get(series.getKey());
            if (visible == null || visible.booleanValue()) {
                this.renderer.setSeriesShapesVisible(indexOfSeries, true);
            } else {
                this.renderer.setSeriesShapesVisible(indexOfSeries, false);
            }
            this.renderer.setSeriesLinesVisible(indexOfSeries, false);
        }
    }

    Map<String, XYSeriesExtension> createDottedSeries(List<DataSet> dataSets) {
        HashMap<String, XYSeriesExtension> result = new HashMap<String, XYSeriesExtension>();
        for (DataSet dataSet : dataSets) {
            String dataSetName = dataSet.getName();
            Paint seriesColor = this.getSeriesColor(dataSetName);
            XYDottedSeriesExtension serie = new XYDottedSeriesExtension(dataSetName, false, true, seriesColor);
            result.put(dataSetName, serie);
        }
        return result;
    }
}

