/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.LoadUtility;
import com.loadcoder.load.chart.common.CommonSampleGroup;
import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.FilteredData;
import com.loadcoder.load.chart.data.Range;
import com.loadcoder.load.chart.jfreechart.XYDataItemExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.sampling.SampleConcaternator;
import com.loadcoder.load.chart.sampling.SampleConcaternatorRunDecider;
import com.loadcoder.load.chart.sampling.SampleConcaternatorSpec;
import com.loadcoder.load.chart.sampling.SampleGroup;
import com.loadcoder.load.chart.utilities.Utilities;
import com.loadcoder.load.scenario.RuntimeResultConsumer;
import com.loadcoder.result.TransactionExecutionResult;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeChartLogic
extends ChartLogic
implements RuntimeResultConsumer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, XYSeriesExtension> seriesMap = new HashMap<String, XYSeriesExtension>();
    private long[] minmax = new long[]{Long.MAX_VALUE, Long.MIN_VALUE};
    private long firstTsToBeReceived;
    private long tsForFirstUpdateContainingData = Long.MAX_VALUE;
    protected List<SampleConcaternator> sampleConcaternatorList = new ArrayList<SampleConcaternator>();
    private final Set<Long> sampleTimestamps = new HashSet<Long>();
    private long updateTimestamp;
    private Map<String, SampleGroup> sampleGroups = new HashMap<String, SampleGroup>();
    private final List<SampleConcaternatorSpec> concaterSpecList;
    private Map<String, CommonSampleGroup> samplesCommonMap = new HashMap<String, CommonSampleGroup>();
    private List<CommonSampleGroup> sampleGroupCommonList = new ArrayList<CommonSampleGroup>();
    private Map<String, List<TransactionExecutionResult>> incomingData;

    public List<SampleConcaternator> getSampleConcaternatorList() {
        return this.sampleConcaternatorList;
    }

    public void setIncomingData(Map<String, List<TransactionExecutionResult>> incomingData) {
        this.incomingData = incomingData;
    }

    public Map<String, SampleGroup> getSampleGroups() {
        return this.sampleGroups;
    }

    public RuntimeChartLogic(CommonSeries[] commonSeries, boolean locked) {
        super(commonSeries, locked);
        this.setSampleLengthToUse(1000L);
        this.concaterSpecList = this.getSampleConcaternatorSpecs();
        this.ranges.addRange(new Range(Long.MIN_VALUE, -1L, this.getSampleLengthToUse()));
        this.ranges.addRange(new Range(0L, Long.MAX_VALUE, this.getSampleLengthToUse()));
        this.initiateChart();
    }

    public int getIncomingSize(Map<String, List<TransactionExecutionResult>> listOfListOfList, List<String> seriesKeys) {
        int size = 0;
        if (listOfListOfList == null) {
            return 0;
        }
        for (String key : seriesKeys) {
            List<TransactionExecutionResult> list = listOfListOfList.get(key);
            if (list == null) continue;
            size += list.size();
        }
        return size;
    }

    public void updateRangesForSampleConcaternatorAfterConcaternation(SampleConcaternator concater) {
        Range oldRange = concater.getOldRange();
        Range newRange = concater.getNewRange();
        long newSampleLength = oldRange.getSampleLength() * (long)concater.getAmountToConcaternate();
        long start = oldRange.getStart();
        long newStart = start + newSampleLength;
        oldRange.setStart(newStart);
        newRange.setEnd(newStart - 1L);
        boolean drawDebugLines = false;
        if (drawDebugLines) {
            this.drawRangeDebugStartLines(oldRange, newStart);
        }
    }

    private void drawRangeDebugStartLines(Range oldRange, long newStart) {
        if (oldRange.getSeries() == null) {
            Color c = this.getNewColor("" + oldRange.getSampleLength());
            oldRange.setSeries(new XYSeriesExtension("" + oldRange.getSampleLength(), true, false, c));
            this.addSeries(oldRange.getSeries());
        } else {
            oldRange.getSeries().clear();
        }
        oldRange.setHigh(new XYDataItemExtension(newStart + 1L, 5000.0));
        oldRange.setLow(new XYDataItemExtension(newStart, 0.0));
        oldRange.getSeries().add(oldRange.getHigh());
        oldRange.getSeries().add(oldRange.getLow());
    }

    public Set<Long> getConcatedTimestamps(SampleConcaternator concater) {
        HashSet<Long> result = new HashSet<Long>();
        long start = concater.getOldRange().getStart();
        long oldSampleLength = concater.getOldRange().getSampleLength();
        long amount = concater.getAmountToConcaternate();
        long tsToRemove = start;
        int i = 1;
        while ((long)i < amount) {
            result.add(tsToRemove += oldSampleLength);
            ++i;
        }
        return result;
    }

    public void concatAndAdjustRanges(SampleConcaternator concater, Set<Long> hashesGettingUpdated) {
        for (String key : this.getSeriesKeys()) {
            SampleGroup sampleGroup = this.sampleGroups.get(key);
            SampleGroup.ConcaternationResult concaternationResult = sampleGroup.concaternate(concater);
            concaternationResult.fixPointsForSeries(sampleGroup.getSeries());
        }
        this.log.trace("old range:{}", (Object)concater.getOldRange());
        this.log.trace("new range:{}", (Object)concater.getNewRange());
        for (CommonSampleGroup sampleGroup : this.sampleGroupCommonList) {
            sampleGroup.concaternate(concater);
        }
        Set<Long> concatedTimestampsToRemove = this.getConcatedTimestamps(concater);
        this.sampleTimestamps.removeAll(concatedTimestampsToRemove);
        hashesGettingUpdated.add(concater.getOldRange().getStart());
        this.updateRangesForSampleConcaternatorAfterConcaternation(concater);
    }

    protected void concat(HashSet<Long> hashesGettingUpdated) {
        long start = System.currentTimeMillis();
        int mostConcatsAtOnce = 1000;
        block0: for (SampleConcaternator concater : this.getSampleConcaternatorList()) {
            int i = 0;
            while (concater.getSampleConcaternatorRunDecider().timeForConcaternation(concater)) {
                this.concatAndAdjustRanges(concater, hashesGettingUpdated);
                if (i++ <= mostConcatsAtOnce) continue;
                continue block0;
            }
        }
        LoadUtility.logExecutionTime((String)"concatenation", (long)start);
    }

    void performUpdate() {
        HashSet<Long> hashesGettingUpdated = new HashSet<Long>();
        this.concat(hashesGettingUpdated);
        this.log.trace("hashes after concat removed samples {}", hashesGettingUpdated);
        this.update(this.incomingData, hashesGettingUpdated);
        this.addNewSampleConcaternaterIfItsTime();
    }

    @Override
    public void update(Map<String, List<TransactionExecutionResult>> incomingData, HashSet<Long> hashesGettingUpdated) {
        List<String> seriesKeys = this.getSeriesKeys();
        incomingData.keySet().stream().forEach(key -> this.addSeriesKey((String)key));
        int incomingSize = this.getIncomingSize(incomingData, seriesKeys);
        if (incomingSize == 0) {
            this.updateCommonsWithSamples(hashesGettingUpdated, this.sampleGroups, this.samplesCommonMap, this.sampleGroupCommonList);
            return;
        }
        long[] minmaxNew = Utilities.findMinMaxTimestamp(incomingData, this.getSeriesKeys());
        this.updateTimestamp = minmaxNew[1];
        if (this.tsForFirstUpdateContainingData == Long.MAX_VALUE) {
            this.tsForFirstUpdateContainingData = minmaxNew[0];
        }
        if (minmaxNew[0] < this.minmax[0]) {
            this.minmax[0] = minmaxNew[0];
        }
        if (minmaxNew[1] > this.minmax[1]) {
            this.minmax[1] = minmaxNew[1];
        }
        if (this.firstTsToBeReceived == 0L) {
            this.firstTsToBeReceived = this.minmax[0];
        }
        long[] minmaxPoints = new long[]{0L, this.minmax[1] - this.minmax[0]};
        List<DataSet> dataSets = Utilities.convert(incomingData, this.firstTsToBeReceived, true, this.getSeriesKeys());
        this.setFilteredData(new FilteredData(dataSets, this.minmax, minmaxPoints));
        this.addToSeriesKeys(this.getFilteredData(), this.getSeriesKeys());
        for (DataSetUserType type : this.getRemovalFiltersInUse()) {
            type.getDataSetUser().useDataSet(dataSets);
        }
        this.getSerieses(this.getFilteredData().getDataSets(), this.seriesMap);
        this.addSeriesNotAdded(this.seriesMap);
        this.createSamplesGroups(this.seriesMap, this.sampleGroups);
        this.addPoints(this.getFilteredData().getDataSets(), this.sampleGroups, this.sampleTimestamps);
        this.updateSeriesWithSamples(hashesGettingUpdated, this.getFilteredData().getDataSets(), this.sampleGroups, this.sampleTimestamps, false);
        this.updateCommonsWithSamples(hashesGettingUpdated, this.sampleGroups, this.samplesCommonMap, this.sampleGroupCommonList);
        this.forceRerender();
    }

    private void addSeriesNotAdded(Map<String, XYSeriesExtension> seriesMap) {
        for (String key : this.getSeriesKeys()) {
            if (this.sampleGroups.get(key) != null) continue;
            XYSeriesExtension series = seriesMap.get(key);
            this.addSeries(series);
        }
    }

    public void addNewConcater(int amountOfSamplesToConcaternate, SampleConcaternatorRunDecider sampleConcaternatorRunDecider) {
        Range oldRange = this.ranges.getLastRange();
        long newSampleLength = oldRange.getSampleLength() * (long)amountOfSamplesToConcaternate;
        Range newRange = new Range(0L, -1L, newSampleLength);
        this.ranges.addRange(newRange);
        SampleConcaternator sampleConcaternator = new SampleConcaternator(oldRange, newRange, amountOfSamplesToConcaternate, sampleConcaternatorRunDecider);
        this.getSampleConcaternatorList().add(sampleConcaternator);
    }

    public void addNewSampleConcaternaterIfItsTime() {
        SampleConcaternatorSpec s;
        long howLongAfterStart;
        if (!this.concaterSpecList.isEmpty() && !this.ranges.isRangesEmpty() && this.updateTimestamp - (howLongAfterStart = (s = this.concaterSpecList.get(0)).getHowLongAfterStartShouldThisBeAdded()) > this.tsForFirstUpdateContainingData) {
            this.logger.debug("Starting a new concater: {}", (Object)s);
            this.concaterSpecList.remove(0);
            this.addNewConcater(s.getAmoutThatShouldBeConcaternated(), s.getSampleConcaternatorRunDecider());
        }
    }

    protected static SampleConcaternatorSpec getNewSpec(ConcatenationDefinition def) {
        int amountToConcat = def.amountToConcatenate;
        long minSizeOfOldRane = def.width;
        return new SampleConcaternatorSpec(minSizeOfOldRane, amountToConcat, a -> {
            long minSizeOfOldRange2 = minSizeOfOldRane;
            Range newRange = a.getNewRange();
            Range oldRange = a.getOldRange();
            long endOfTheNewRange = newRange.getEnd();
            long endOfTheOldRange = oldRange.getEnd();
            long diff = endOfTheOldRange - endOfTheNewRange;
            return diff > minSizeOfOldRange2;
        });
    }

    SampleConcaternatorRunDecider getFirstConcaterRunDecider(long widthOfUnconcatenatedRange) {
        SampleConcaternatorRunDecider firstConcater = a -> {
            Long higest = this.highestX;
            long startOfOldRange = a.getOldRange().getStart();
            return higest > startOfOldRange + widthOfUnconcatenatedRange;
        };
        return firstConcater;
    }

    public List<SampleConcaternatorSpec> getSampleConcaternatorSpecs() {
        ArrayList<SampleConcaternatorSpec> concaterSpecs = new ArrayList<SampleConcaternatorSpec>();
        ConcatenationDefinition firstConcatenationDefinition = new ConcatenationDefinition(120000L, 4);
        concaterSpecs.add(new SampleConcaternatorSpec(firstConcatenationDefinition.width, firstConcatenationDefinition.amountToConcatenate, this.getFirstConcaterRunDecider(firstConcatenationDefinition.width)));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(new ConcatenationDefinition(6000000L, 4)));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(new ConcatenationDefinition(2400000L, 8)));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(new ConcatenationDefinition(18000000L, 8)));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(new ConcatenationDefinition(172800000L, 8)));
        return concaterSpecs;
    }

    @Override
    protected void doUpdate() {
        this.performUpdate();
    }

    public void useData(Map<String, List<TransactionExecutionResult>> transactionsMap) {
        this.getChart().setNotify(false);
        this.setIncomingData(transactionsMap);
        long start = System.currentTimeMillis();
        this.doSafeUpdate();
        long diff = System.currentTimeMillis() - start;
        this.logger.debug("update time: {}", (Object)diff);
        this.getChart().setNotify(true);
        this.logger.trace("Total Points in chart: {}", (Object)this.getTotalSize());
    }

    protected static class ConcatenationDefinition {
        long width;
        int amountToConcatenate;

        public ConcatenationDefinition(long widthOfPreviousRangeBeforeConcatenation, int amountToConcatenate) {
            this.width = widthOfPreviousRangeBeforeConcatenation;
            this.amountToConcatenate = amountToConcatenate;
        }
    }
}

