/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.sampling;

import com.loadcoder.load.chart.common.YCalculator;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.load.chart.jfreechart.XYDataItemExtension;
import com.loadcoder.load.chart.sampling.SampleBase;
import java.util.ArrayList;
import java.util.List;

public class Sample
extends SampleBase {
    private boolean locked = true;
    long pointsSum = 0L;
    long pointsAmount = 0L;
    boolean empty = true;
    int amountOfFails = 0;
    String seriesName;
    private List<Point> points = new ArrayList<Point>();

    public Sample(long startTs, long length, String seriesName, boolean locked) {
        this(startTs, length, seriesName);
        this.locked = locked;
    }

    public Sample(long startTs, long length, String seriesName) {
        this.firstTs = startTs;
        this.lastTs = startTs + length - 1L;
        this.length = length;
        this.seriesName = seriesName;
    }

    public String toString() {
        return "{" + this.firstTs + " - " + this.lastTs + ", y:" + this.y + "}";
    }

    public int getAmountOfFails() {
        return this.amountOfFails;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPointsSum(long pointSum) {
        this.pointsSum = pointSum;
    }

    public void setPointsAmount(long pointsAmount) {
        this.pointsAmount = pointsAmount;
    }

    public void setPoints(List<Point> points) {
        if (this.locked) {
            this.pointsAmount = points.size();
        } else {
            this.points = points;
        }
    }

    public boolean isEmpty() {
        if (this.locked) {
            return this.pointsAmount == 0L;
        }
        return this.points.isEmpty();
    }

    public List<Point> scrapThisSampleAndGetPoints() {
        List<Point> toBeReturned = this.points;
        this.points = null;
        this.pointsSum = -1L;
        this.pointsAmount = -1L;
        return toBeReturned;
    }

    public void increaseFails() {
        ++this.amountOfFails;
    }

    public void setFails(int amountOfFails) {
        this.amountOfFails = amountOfFails;
    }

    public void setFirst(XYDataItemExtension first) {
        this.first = first;
    }

    public long getPointsSum() {
        return this.pointsSum;
    }

    public long getAmountOfPoints() {
        if (this.locked) {
            return this.pointsAmount;
        }
        return this.points.size();
    }

    public void addPoint(Point point) {
        if (this.locked) {
            this.pointsSum += point.getY();
            ++this.pointsAmount;
        } else {
            this.points.add(point);
        }
    }

    public static long amountToYValue(double amount) {
        long longAmount = (long)amount;
        if (amount > (double)longAmount) {
            ++longAmount;
        }
        return longAmount;
    }

    public static double avg(long sum, long amount) {
        double avg = (double)sum / (double)amount;
        return avg;
    }

    public void calculateY(YCalculator calc) {
        double calculated = this.locked ? Sample.avg(this.pointsSum, this.pointsAmount) : calc.calculateY(this.points);
        this.y = Math.round(calculated);
    }

    @Override
    public long getY() {
        return this.y;
    }
}

