/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.utilities;

import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.result.TransactionExecutionResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Utilities {
    public static long[] findMinMaxTimestamp(Map<String, List<TransactionExecutionResult>> resultLists, List<String> keys) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (String key : keys) {
            List<TransactionExecutionResult> resultList = resultLists.get(key);
            if (resultList == null) continue;
            for (TransactionExecutionResult result : resultList) {
                if (result.getTs() < min) {
                    min = result.getTs();
                }
                if (result.getTs() <= max) continue;
                max = result.getTs();
            }
        }
        return new long[]{min, max};
    }

    public static List<DataSet> convert(Map<String, List<TransactionExecutionResult>> resultLists, long earliestTs, boolean convertToRelativeTime, List<String> keys) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        if (resultLists.isEmpty()) {
            return dataSets;
        }
        for (String key : keys) {
            List<TransactionExecutionResult> resultList = resultLists.get(key);
            if (resultList == null) continue;
            DataSet dataSet = new DataSet(key, new ArrayList<Point>());
            dataSets.add(dataSet);
            for (TransactionExecutionResult result : resultList) {
                if (convertToRelativeTime) {
                    dataSet.getPoints().add(new Point(result.getTs() - earliestTs, result.getValue(), result.isStatus()));
                    continue;
                }
                dataSet.getPoints().add(new Point(result.getTs(), result.getValue(), result.isStatus()));
            }
        }
        return dataSets;
    }
}

