/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.extra.jackson.JSONErrorParser;
import com.marklogic.client.impl.FailedRequestParser;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FailedRequest {
    private String messageCode;
    private String messageString;
    private int statusCode;
    private String statusString;

    public static FailedRequest getFailedRequest(int httpStatus, MediaType contentType, InputStream content) {
        FailedRequest failure;
        if (contentType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            FailedRequestXMLParser xmlParser = new FailedRequestXMLParser();
            failure = xmlParser.parseFailedRequest(httpStatus, content);
        } else if (contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            failure = FailedRequest.jsonFailedRequest(httpStatus, content);
        } else {
            failure = new FailedRequest();
            failure.setStatusCode(httpStatus);
            failure.setMessageCode("UNKNOWN");
            failure.setMessageString("Server (not a REST instance?) did not respond with an expected REST Error message.");
            failure.setStatusString("UNKNOWN");
        }
        if (failure.getStatusCode() == 401) {
            failure.setMessageString("Unauthorized");
            failure.setStatusString("Failed Auth");
        }
        return failure;
    }

    private static FailedRequest jsonFailedRequest(int httpStatus, InputStream content) {
        return new JSONErrorParser().parseFailedRequest(httpStatus, content);
    }

    public String getMessage() {
        return this.messageString;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String getStatus() {
        return this.statusString;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public void setMessageString(String messageString) {
        this.messageString = messageString;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }

    private static class FailedRequestXMLParser
    implements FailedRequestParser {
        private FailedRequestXMLParser() {
        }

        @Override
        public FailedRequest parseFailedRequest(int httpStatus, InputStream is) {
            FailedRequest failure = new FailedRequest();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                String statusCode = doc.getElementsByTagNameNS("http://marklogic.com/rest-api", "status-code").item(0).getTextContent();
                failure.setStatusCode(Integer.parseInt(statusCode));
                failure.setStatusString(doc.getElementsByTagNameNS("http://marklogic.com/rest-api", "status").item(0).getTextContent());
                failure.setMessageCode(doc.getElementsByTagNameNS("http://marklogic.com/rest-api", "message-code").item(0).getTextContent());
                failure.setMessageString(doc.getElementsByTagNameNS("http://marklogic.com/rest-api", "message").item(0).getTextContent());
            }
            catch (ParserConfigurationException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Unable to parse server error.");
            }
            catch (SAXException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Unable to parse server error details");
            }
            catch (IOException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Error body not received from server");
            }
            return failure;
        }
    }
}

