/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.util.NameMap;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class NameMapBase<V>
extends HashMap<QName, V>
implements NameMap<V> {
    private NamespaceContext context;

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) {
        this.context = context;
    }

    @Override
    public boolean containsKey(String name) {
        return super.containsKey(this.makeQName(name));
    }

    @Override
    public V get(String name) {
        return super.get(this.makeQName(name));
    }

    @Override
    public <T> T get(QName name, Class<T> as) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        if (as.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw new IllegalArgumentException("Cannot get value of " + value.getClass().getName() + " as " + as.getName());
    }

    @Override
    public <T> T get(String name, Class<T> as) {
        return this.get(this.makeQName(name), as);
    }

    @Override
    public V put(String name, V value) {
        return this.put(this.makeQName(name), value);
    }

    @Override
    public V remove(String name) {
        return super.remove(this.makeQName(name));
    }

    protected QName makeQName(String name) {
        String uri;
        if (name == null) {
            return null;
        }
        if (name.contains(":")) {
            if (this.context == null) {
                throw new IllegalStateException("No namespace context for resolving key with prefix: " + name);
            }
            String[] parts = name.split(":", 2);
            String prefix = parts[0];
            if (prefix == null) {
                throw new IllegalArgumentException("Empty prefix in key: " + name);
            }
            String localPart = parts[1];
            if (localPart == null) {
                throw new IllegalArgumentException("Empty local part in key: " + name);
            }
            String uri2 = this.context.getNamespaceURI(prefix);
            if (uri2 == null || "".equals(uri2)) {
                throw new IllegalStateException("No namespace uri defined in context for prefix " + prefix + " of key: " + name);
            }
            return new QName(uri2, localPart, prefix);
        }
        if (this.context != null && (uri = this.context.getNamespaceURI("")) != null && !"".equals(uri)) {
            return new QName(uri, name);
        }
        return new QName(name);
    }
}

