/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.admin.ExtensionMetadata;
import com.marklogic.client.admin.ResourceExtensionsManager;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.util.RequestParameters;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceExtensionsImpl
extends AbstractLoggingManager
implements ResourceExtensionsManager {
    private static final Logger logger = LoggerFactory.getLogger(ResourceExtensionsImpl.class);
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

    ResourceExtensionsImpl(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public <T> T listServicesAs(Format format, Class<T> as) {
        return this.listServicesAs(format, as, true);
    }

    @Override
    public <T> T listServicesAs(Format format, Class<T> as, boolean refresh) {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (!StructureReadHandle.class.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to list resource services as " + as.getName());
        }
        Utilities.setHandleStructuredFormat(handle, format);
        this.listServices((StructureReadHandle)((Object)handle), refresh);
        return handle.get();
    }

    @Override
    public <T extends StructureReadHandle> T listServices(T listHandle) {
        return this.listServices(listHandle, true);
    }

    @Override
    public <T extends StructureReadHandle> T listServices(T listHandle, boolean refresh) {
        HandleImplementation listBase;
        Format listFormat;
        if (listHandle == null) {
            throw new IllegalArgumentException("null handle for listing resource services");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Reading resource services list");
        }
        if (Format.JSON != (listFormat = (listBase = HandleAccessor.checkHandle(listHandle, "resource")).getFormat()) && Format.XML != listFormat) {
            throw new IllegalArgumentException("list handle for unsupported format: " + ((Object)((Object)listFormat)).getClass().getName());
        }
        RequestParameters extraParams = null;
        if (!refresh) {
            extraParams = new RequestParameters();
            extraParams.put("refresh", "false");
        }
        listBase.receiveContent(this.services.getValues(this.requestLogger, "config/resources", extraParams, listFormat.getDefaultMimetype(), listBase.receiveAs()));
        return listHandle;
    }

    @Override
    public <T> T readServicesAs(String resourceName, Class<T> as) {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (!TextReadHandle.class.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to read resource service source as " + as.getName());
        }
        this.readServices(resourceName, (TextReadHandle)((Object)handle));
        return handle.get();
    }

    @Override
    public <T extends TextReadHandle> T readServices(String resourceName, T sourceHandle) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Reading resource services source with null name");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Reading resource services source for {}", (Object)resourceName);
        }
        HandleImplementation sourceBase = HandleAccessor.checkHandle(sourceHandle, "resource");
        sourceBase.receiveContent(this.services.getValue(this.requestLogger, "config/resources", resourceName, true, "application/xquery", sourceBase.receiveAs()));
        return sourceHandle;
    }

    @Override
    public void writeServicesAs(String resourceName, Object source, ExtensionMetadata metadata, ResourceExtensionsManager.MethodParameters ... methodParams) {
        if (source == null) {
            throw new IllegalArgumentException("no source to write");
        }
        Class<?> as = source.getClass();
        TextWriteHandle sourceHandle = null;
        if (TextWriteHandle.class.isAssignableFrom(as)) {
            sourceHandle = (TextWriteHandle)source;
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            if (!TextWriteHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to write resource service source as " + as.getName());
            }
            Utilities.setHandleContent(handle, source);
            sourceHandle = (TextWriteHandle)((Object)handle);
        }
        this.writeServices(resourceName, sourceHandle, metadata, methodParams);
    }

    @Override
    public void writeServices(String resourceName, TextWriteHandle sourceHandle, ExtensionMetadata metadata, ResourceExtensionsManager.MethodParameters ... methodParams) {
        RequestParameters extraParams;
        if (resourceName == null) {
            throw new IllegalArgumentException("Writing resource services with null name");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Writing resource services source for {}", (Object)resourceName);
        }
        HandleImplementation sourceBase = HandleAccessor.checkHandle(sourceHandle, "resource");
        RequestParameters requestParameters = extraParams = metadata != null ? metadata.asParameters() : new RequestParameters();
        if (methodParams != null) {
            for (ResourceExtensionsManager.MethodParameters params : methodParams) {
                String method = params.getMethod().toString().toLowerCase();
                extraParams.add("method", method);
                String prefix = method + ":";
                for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                    extraParams.put(prefix + entry.getKey(), entry.getValue());
                }
            }
        }
        this.services.putValue(this.requestLogger, "config/resources", resourceName, extraParams, "application/xquery", sourceBase);
    }

    @Override
    public void deleteServices(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Deleting resource services with null name");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Deleting resource services for {}", (Object)resourceName);
        }
        this.services.deleteValue(this.requestLogger, "config/resources", resourceName);
    }
}

