/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.ResourceNotResendableException;
import com.marklogic.client.admin.ExtensionLibrariesManager;
import com.marklogic.client.admin.ExtensionLibraryDescriptor;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.XMLEventReaderHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.util.RequestParameters;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ExtensionLibrariesManagerImpl
extends AbstractLoggingManager
implements ExtensionLibrariesManager {
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

    public ExtensionLibrariesManagerImpl(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public ExtensionLibraryDescriptor[] list() throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.list("/ext");
    }

    @Override
    public ExtensionLibraryDescriptor[] list(String directory) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        XMLEventReaderHandle handle = this.services.getResource(this.requestLogger, directory, null, new XMLEventReaderHandle());
        XMLEventReader reader = handle.get();
        ArrayList<ExtensionLibraryDescriptor> modules = new ArrayList<ExtensionLibraryDescriptor>();
        while (reader.hasNext()) {
            try {
                XMLEvent event = reader.nextEvent();
                if (!event.isCharacters()) continue;
                String modulePath = event.asCharacters().getData();
                ExtensionLibraryDescriptor module = new ExtensionLibraryDescriptor();
                module.setPath(modulePath);
                modules.add(module);
            }
            catch (XMLStreamException e) {
                throw new MarkLogicIOException(e);
            }
        }
        return modules.toArray(new ExtensionLibraryDescriptor[0]);
    }

    @Override
    public <T> T readAs(String modulePath, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        this.read(modulePath, handle);
        return handle.get();
    }

    @Override
    public <T> T read(ExtensionLibraryDescriptor modulesDescriptor, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        this.read(modulesDescriptor, handle);
        return handle.get();
    }

    @Override
    public <T extends AbstractReadHandle> T read(String modulePath, T readHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.services.getResource(this.requestLogger, modulePath, null, readHandle);
    }

    @Override
    public <T extends AbstractReadHandle> T read(ExtensionLibraryDescriptor modulesDescriptor, T readHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.read(modulesDescriptor.getPath(), readHandle);
    }

    @Override
    public void writeAs(String modulePath, Object content) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.write(modulePath, this.getContentHandle(content));
    }

    @Override
    public void writeAs(ExtensionLibraryDescriptor modulesDescriptor, Object content) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.write(modulesDescriptor, this.getContentHandle(content));
    }

    private AbstractWriteHandle getContentHandle(Object content) {
        if (content == null) {
            throw new IllegalArgumentException("no content to write");
        }
        Class<?> as = content.getClass();
        ContentHandle<?> contentHandle = null;
        if (AbstractWriteHandle.class.isAssignableFrom(as)) {
            contentHandle = (ContentHandle<?>)content;
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            Utilities.setHandleContent(handle, content);
            contentHandle = handle;
        }
        return contentHandle;
    }

    @Override
    public void write(String modulePath, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.services.putResource(this.requestLogger, modulePath, null, contentHandle, null);
    }

    @Override
    public void write(ExtensionLibraryDescriptor modulesDescriptor, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        RequestParameters requestParams = new RequestParameters();
        for (ExtensionLibraryDescriptor.Permission perm : modulesDescriptor.getPermissions()) {
            requestParams.add("perm:" + perm.getRoleName(), perm.getCapability());
        }
        this.services.putResource(this.requestLogger, modulesDescriptor.getPath(), requestParams, contentHandle, null);
    }

    @Override
    public void delete(String modulePath) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.services.deleteResource(this.requestLogger, modulePath, null, null);
    }

    @Override
    public void delete(ExtensionLibraryDescriptor modulesDescriptor) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        this.delete(modulesDescriptor.getPath());
    }
}

