/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HandleAccessor {
    public static HandleImplementation checkHandle(Object object, String type) {
        if (!HandleAccessor.isHandle(object)) {
            throw new IllegalArgumentException(type + " handle does not extend BaseHandle: " + object.getClass().getName());
        }
        return (HandleImplementation)object;
    }

    public static boolean isHandle(Object object) {
        return object == null || object instanceof BaseHandle;
    }

    public static <R extends AbstractReadHandle> Class<R> receiveAs(R handle) {
        if (handle == null) {
            return null;
        }
        return ((HandleImplementation)((Object)handle)).receiveAs();
    }

    public static <R extends AbstractReadHandle> void receiveContent(R handle, Object content) {
        if (handle == null) {
            return;
        }
        ((HandleImplementation)((Object)handle)).receiveContent(content);
    }

    public static <W extends AbstractWriteHandle> Object sendContent(W handle) {
        if (handle == null) {
            return null;
        }
        return ((HandleImplementation)((Object)handle)).sendContent();
    }

    public static <W extends AbstractWriteHandle> boolean isResendable(W handle) {
        if (handle == null) {
            return false;
        }
        return ((HandleImplementation)((Object)handle)).isResendable();
    }

    public static HandleImplementation as(Object handle) {
        return (HandleImplementation)handle;
    }

    public static String contentAsString(AbstractWriteHandle handle) {
        try {
            Object content = HandleAccessor.sendContent(handle);
            if (content == null) {
                return null;
            }
            String stringContent = null;
            if (content instanceof String) {
                stringContent = (String)content;
            } else if (content instanceof OutputStreamSender) {
                ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
                ((OutputStreamSender)content).write(bytesStream);
                stringContent = bytesStream.toString("UTF-8");
            } else if (content instanceof byte[]) {
                stringContent = new String((byte[])content, "UTF-8");
            } else if (content instanceof File) {
                content = new FileInputStream((File)content);
            }
            if (content instanceof InputStream) {
                StringBuffer sb = new StringBuffer();
                InputStreamReader reader = new InputStreamReader((InputStream)content, "UTF-8");
                char[] cbuf = new char[8000];
                int charsRead = -1;
                while ((charsRead = reader.read(cbuf)) != -1) {
                    sb.append(cbuf, 0, charsRead);
                }
                stringContent = sb.toString();
            }
            if (content instanceof File) {
                ((FileInputStream)content).close();
            }
            if (stringContent == null) {
                throw new UnsupportedOperationException("contentAsString only supports handles with sendContent() of type String, OutputStreamSender, byte[], File, or InputStream");
            }
            return stringContent;
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }
}

