/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.Transaction;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.marker.StructureReadHandle;

class TransactionImpl
implements Transaction {
    static final int DEFAULT_TIMELIMIT = -1;
    private RESTServices services;
    private String transactionId;

    TransactionImpl(RESTServices services, String transactionId) {
        this.services = services;
        this.transactionId = transactionId;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public <T extends StructureReadHandle> T readStatus(T handle) throws ForbiddenUserException, FailedRequestException {
        if (handle == null) {
            throw new IllegalArgumentException("reading transaction status with null handle");
        }
        HandleImplementation handleBase = HandleAccessor.checkHandle(handle, "structure");
        handleBase.receiveContent(this.services.getValue(null, "transactions", this.getTransactionId(), false, handleBase.getMimetype(), handleBase.receiveAs()));
        return handle;
    }

    @Override
    public void commit() throws ForbiddenUserException, FailedRequestException {
        this.services.commitTransaction(this.getTransactionId());
    }

    @Override
    public void rollback() throws ForbiddenUserException, FailedRequestException {
        this.services.rollbackTransaction(this.getTransactionId());
    }
}

