/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.JAXBHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;

public class DOMNodeHandle<T extends Node>
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<T>,
XMLReadHandle,
XMLWriteHandle {
    private static final Logger logger = LoggerFactory.getLogger(JAXBHandle.class);
    private T content;
    private DocumentBuilderFactory factory;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return null;
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return (Boolean)null;
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                return null;
            }
        };
    }

    public DOMNodeHandle() {
        this.setResendable(true);
    }

    public DOMNodeHandle(T content) {
        this();
        this.set(content);
    }

    @Override
    public T get() {
        return this.content;
    }

    @Override
    public void set(T content) {
        this.content = content;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public DocumentBuilderFactory getFactory() throws ParserConfigurationException {
        if (this.factory == null) {
            this.factory = this.makeDocumentBuilderFactory();
        }
        return this.factory;
    }

    public void setFactory(DocumentBuilderFactory factory) {
        this.factory = factory;
    }

    protected DocumentBuilderFactory makeDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        return factory;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            this.content = null;
            return;
        }
        try {
            DocumentBuilderFactory factory;
            if (logger.isInfoEnabled()) {
                logger.info("Parsing DOM document from input stream");
            }
            if ((factory = this.getFactory()) == null) {
                throw new MarkLogicInternalException("Failed to make DOM document builder factory");
            }
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)factory.newDocumentBuilder().getDOMImplementation());
            LSParser parser = domImpl.createLSParser((short)1, null);
            LSInput domInput = domImpl.createLSInput();
            domInput.setEncoding("UTF-8");
            domInput.setByteStream(content);
            this.content = parser.parse(domInput);
            content.close();
        }
        catch (IOException e) {
            logger.error("Failed to parse DOM document from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Failed to parse DOM document from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No document to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            DocumentBuilderFactory factory;
            if (logger.isInfoEnabled()) {
                logger.info("Serializing DOM document to output stream");
            }
            if ((factory = this.getFactory()) == null) {
                throw new MarkLogicInternalException("Failed to make DOM document builder factory");
            }
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)factory.newDocumentBuilder().getDOMImplementation());
            LSOutput domOutput = domImpl.createLSOutput();
            domOutput.setEncoding("UTF-8");
            domOutput.setByteStream(out);
            domImpl.createLSSerializer().write((Node)this.content, domOutput);
        }
        catch (DOMException e) {
            logger.error("Failed to serialize DOM document to output stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (LSException e) {
            logger.error("Failed to serialize DOM document to output stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Failed to serialize DOM document to output stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }
}

