/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.JacksonBaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class JacksonHandle
extends JacksonBaseHandle<JsonNode>
implements ContentHandle<JsonNode>,
OutputStreamSender,
BufferableHandle,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private JsonNode content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{JsonNode.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return JsonNode.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                JacksonHandle handle = this.isHandled(type) ? new JacksonHandle() : null;
                return handle;
            }
        };
    }

    public JacksonHandle() {
        this.setResendable(true);
    }

    public JacksonHandle(JsonNode content) {
        this();
        this.set(content);
    }

    public JacksonHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    @Override
    public JsonNode get() {
        return this.content;
    }

    @Override
    public void set(JsonNode content) {
        this.content = content;
    }

    public JacksonHandle with(JsonNode content) {
        this.set(content);
        return this;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            return;
        }
        try {
            this.set((JsonNode)this.getMapper().readValue((Reader)new InputStreamReader(content, "UTF-8"), JsonNode.class));
        }
        catch (JsonParseException e) {
            throw new MarkLogicIOException(e);
        }
        catch (JsonMappingException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected boolean hasContent() {
        return this.content != null;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.getMapper().writeValue((Writer)new OutputStreamWriter(out, "UTF-8"), (Object)this.get());
    }
}

