/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStreamReaderHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<XMLStreamReader>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private static final Logger logger = LoggerFactory.getLogger(XMLStreamReaderHandle.class);
    private XMLResolver resolver;
    private XMLStreamReader content;
    private XMLInputFactory factory;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{XMLStreamReader.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return XMLStreamReader.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                XMLStreamReaderHandle handle = this.isHandled(type) ? new XMLStreamReaderHandle() : null;
                return handle;
            }
        };
    }

    public XMLStreamReaderHandle() {
        super.setFormat(Format.XML);
        this.setResendable(false);
    }

    public XMLStreamReaderHandle(XMLStreamReader content) {
        this();
        this.set(content);
    }

    public XMLResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(XMLResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public XMLStreamReader get() {
        return this.content;
    }

    @Override
    public void set(XMLStreamReader content) {
        this.content = content;
    }

    public XMLStreamReaderHandle with(XMLStreamReader content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("XMLStreamReaderHandle supports the XML format only");
        }
    }

    public XMLStreamReaderHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            byte[] b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public XMLInputFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.makeXMLInputFactory();
        }
        return this.factory;
    }

    public void setFactory(XMLInputFactory factory) {
        this.factory = factory;
    }

    protected XMLInputFactory makeXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        factory.setProperty("javax.xml.stream.isValidating", false);
        return factory;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            this.content = null;
            return;
        }
        try {
            XMLInputFactory factory;
            if (logger.isInfoEnabled()) {
                logger.info("Parsing StAX stream from input stream");
            }
            if ((factory = this.getFactory()) == null) {
                throw new MarkLogicInternalException("Failed to make StAX input factory");
            }
            if (this.resolver != null) {
                factory.setXMLResolver(this.resolver);
            }
            this.content = factory.createXMLStreamReader(content, "UTF-8");
        }
        catch (XMLStreamException e) {
            logger.error("Failed to parse StAX stream from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (FactoryConfigurationError e) {
            logger.error("Failed to parse StAX stream from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No input source to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            XMLInputFactory inputFactory = this.getFactory();
            if (inputFactory == null) {
                throw new MarkLogicInternalException("Failed to make StAX input factory");
            }
            XMLEventReader reader = inputFactory.createXMLEventReader(this.content);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            XMLEventWriter writer = outputFactory.createXMLEventWriter(out, "UTF-8");
            writer.add(reader);
            writer.flush();
            writer.close();
            this.content.close();
        }
        catch (XMLStreamException e) {
            logger.error("Failed to parse StAX events from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }
}

