/*
 * Copyright 2012-2015 MarkLogic Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marklogic.client.impl;

import com.marklogic.client.query.StringQueryDefinition;

public class StringQueryDefinitionImpl extends AbstractQueryDefinition implements StringQueryDefinition {
    protected String criteria = null;

    public StringQueryDefinitionImpl(String uri) {
        optionsUri = uri;
    }

    @Override
    public String getCriteria() {
        return criteria;
    }

    @Override
    public void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    @Override
    public StringQueryDefinition withCriteria(String criteria) {
    	setCriteria(criteria);
    	return this;
    }
}
