/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.admin.config;

import com.marklogic.client.admin.config.support.Annotatable;
import com.marklogic.client.admin.config.support.Buckets;
import com.marklogic.client.admin.config.support.ConstraintSource;
import com.marklogic.client.admin.config.support.Indexed;
import com.marklogic.client.admin.config.support.MetadataExtract;
import com.marklogic.client.admin.config.support.RangeIndexed;
import com.marklogic.client.admin.config.support.TermIndexed;
import com.marklogic.client.admin.config.support.TermOptions;
import com.marklogic.client.admin.config.support.TermSource;
import com.marklogic.client.admin.config.support.TupleSource;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.util.EditableNamespaceContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(namespace="http://marklogic.com/appservices/search", name="options")
public final class QueryOptions
implements Annotatable<QueryOptions> {
    public static final String DEFAULT_COLLATION = "http://marklogic.com/collation/";
    public static final String SEARCH_NS = "http://marklogic.com/appservices/search";
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="additional-query")
    private QueryAdditionalQuery additionalQuery;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
    private List<QueryAnnotation> annotations;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="concurrency-level")
    private Integer concurrencyLevel;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="debug")
    private Boolean debug;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="default-suggestion-source")
    private QueryDefaultSuggestionSource defaultSuggestionSource;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="forest")
    private List<Long> forests;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="fragment-scope")
    private String fragmentScope;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="grammar")
    private QueryGrammar grammarOption;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="operator")
    private List<QueryOperator> operators;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="page-length")
    private Long pageLength;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="quality-weight")
    private Double qualityWeight;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="constraint")
    private List<QueryConstraint> queryConstraints = new ArrayList<QueryConstraint>();
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="values")
    private List<QueryValues> queryValues;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="tuples")
    private List<QueryTuples> queryTuples;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-aggregates")
    private Boolean returnAggregates;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-constraints")
    private Boolean returnConstraints;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-facets")
    private Boolean returnFacets;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-frequencies")
    private Boolean returnFrequencies;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-metrics")
    private Boolean returnMetrics;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-plan")
    private Boolean returnPlan;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-qtext")
    private Boolean returnQtext;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-query")
    private Boolean returnQuery;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-results")
    private Boolean returnResults;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-similar")
    private Boolean returnSimilar;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="return-values")
    private Boolean returnValues;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="namespace-bindings")
    private ExpressionNamespaceBindings searchableExpressionBindings;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="searchable-expression")
    private QuerySearchableExpression searchableExpression;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="search-option")
    private List<String> searchOptions;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="sort-order")
    private List<QuerySortOrder> sortOrders;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="suggestion-source")
    private List<QuerySuggestionSource> suggestionSources;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="term")
    private QueryTerm termConfig;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="transform-results")
    private QueryTransformResults transformResultsOption;
    @XmlElement(namespace="http://marklogic.com/appservices/search", name="extract-metadata")
    private QueryExtractMetadata extractMetadata;

    public QueryOptions() {
        this.operators = new ArrayList<QueryOperator>();
        this.sortOrders = new ArrayList<QuerySortOrder>();
        this.suggestionSources = new ArrayList<QuerySuggestionSource>();
        this.forests = new ArrayList<Long>();
        this.searchOptions = new ArrayList<String>();
        this.annotations = new ArrayList<QueryAnnotation>();
        this.queryValues = new ArrayList<QueryValues>();
        this.queryTuples = new ArrayList<QueryTuples>();
    }

    public void setSearchableExpressionNamespaceContext(ExpressionNamespaceBinding[] bindingsArray) {
        ExpressionNamespaceBindings bindings = new ExpressionNamespaceBindings();
        for (ExpressionNamespaceBinding binding : bindingsArray) {
            bindings.addBinding(binding.getPrefix(), binding.getNamespaceURI());
        }
        this.searchableExpressionBindings = bindings;
    }

    public void addForest(Long forest) {
        this.forests.add(forest);
    }

    public void addSearchOption(String searchOption) {
        this.searchOptions.add(searchOption);
    }

    public Element getAdditionalQuery() {
        return this.additionalQuery.getValue();
    }

    @Override
    public List<QueryAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public QueryOptions annotate(String xmlAnnotation) {
        this.annotations.add(new QueryAnnotation(xmlAnnotation));
        return this;
    }

    public Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public QueryDefaultSuggestionSource getDefaultSuggestionSource() {
        return this.defaultSuggestionSource;
    }

    public QueryExtractMetadata getExtractMetadata() {
        return this.extractMetadata;
    }

    public List<Long> getForests() {
        return this.forests;
    }

    public String getFragmentScope() {
        return this.fragmentScope;
    }

    public QueryGrammar getGrammar() {
        return this.grammarOption;
    }

    public Long getPageLength() {
        return this.pageLength;
    }

    public Double getQualityWeight() {
        return this.qualityWeight;
    }

    public List<QueryConstraint> getQueryConstraints() {
        if (this.queryConstraints == null) {
            return new ArrayList<QueryConstraint>();
        }
        return this.queryConstraints;
    }

    public List<QueryOperator> getQueryOperators() {
        return this.operators;
    }

    public List<QueryValues> getQueryValues() {
        return this.queryValues;
    }

    public List<QueryTuples> getQueryTuples() {
        return this.queryTuples;
    }

    public Boolean getReturnAggregates() {
        return this.returnAggregates;
    }

    public Boolean getReturnConstraints() {
        return this.returnConstraints;
    }

    public Boolean getReturnFacets() {
        return this.returnFacets;
    }

    public Boolean getReturnFrequencies() {
        return this.returnFrequencies;
    }

    public Boolean getReturnMetrics() {
        return this.returnMetrics;
    }

    public Boolean getReturnPlan() {
        return this.returnPlan;
    }

    public Boolean getReturnQtext() {
        return this.returnQtext;
    }

    public Boolean getReturnQuery() {
        return this.returnQuery;
    }

    public Boolean getReturnResults() {
        return this.returnResults;
    }

    public Boolean getReturnSimilar() {
        return this.returnSimilar;
    }

    public Boolean getReturnValues() {
        return this.returnValues;
    }

    public EditableNamespaceContext getSearchableExpressionNamespaceContext() {
        EditableNamespaceContext context = new EditableNamespaceContext();
        if (this.searchableExpressionBindings != null && this.searchableExpressionBindings.bindings != null) {
            for (ExpressionNamespaceBinding binding : this.searchableExpressionBindings.bindings) {
                String prefix = binding.getPrefix();
                String uri = binding.getNamespaceURI();
                if ("".equals(prefix)) {
                    context.setDefaultNamespaceURI(uri);
                    continue;
                }
                context.setNamespaceURI(prefix, uri);
            }
        }
        return context;
    }

    public String getSearchableExpression() {
        return this.searchableExpression.getPath();
    }

    public List<String> getSearchOptions() {
        return this.searchOptions;
    }

    public List<QuerySortOrder> getSortOrders() {
        return this.sortOrders;
    }

    public List<QuerySuggestionSource> getSuggestionSources() {
        return this.suggestionSources;
    }

    public QueryTerm getTerm() {
        return this.termConfig;
    }

    public QueryTransformResults getTransformResults() {
        return this.transformResultsOption;
    }

    public void setAdditionalQuery(Element additionalQuery) {
        this.additionalQuery = new QueryAdditionalQuery(additionalQuery);
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public void setDefaultSuggestionSource(QueryDefaultSuggestionSource dss) {
        this.defaultSuggestionSource = dss;
    }

    public void setExtractMetadata(QueryExtractMetadata extractMetadata) {
        this.extractMetadata = extractMetadata;
    }

    public void setForests(List<Long> forests) {
        this.forests = new ArrayList<Long>();
        if (forests != null) {
            this.forests.addAll(forests);
        }
    }

    public void setFragmentScope(FragmentScope fragmentScope) {
        this.fragmentScope = fragmentScope == null ? null : fragmentScope.toString().toLowerCase();
    }

    public void setGrammar(QueryGrammar grammarOption) {
        this.grammarOption = grammarOption;
    }

    public void setOperators(List<QueryOperator> operatorOptions) {
        this.operators = operatorOptions;
    }

    public void setPageLength(Long pageLength) {
        this.pageLength = pageLength;
    }

    public void setQualityWeight(Double qualityWeight) {
        this.qualityWeight = qualityWeight;
    }

    public void setQueryValues(List<QueryValues> values) {
        this.queryValues = values;
    }

    public void setQueryTuples(List<QueryTuples> tuples) {
        this.queryTuples = tuples;
    }

    public void setReturnAggregates(Boolean returnAggregates) {
        this.returnAggregates = returnAggregates;
    }

    public void setReturnConstraints(Boolean returnConstraints) {
        this.returnConstraints = returnConstraints;
    }

    public void setReturnFacets(Boolean returnFacets) {
        this.returnFacets = returnFacets;
    }

    public void setReturnFrequencies(Boolean returnFrequencies) {
        this.returnFrequencies = returnFrequencies;
    }

    public void setReturnMetrics(Boolean returnMetrics) {
        this.returnMetrics = returnMetrics;
    }

    public void setReturnPlan(Boolean returnPlan) {
        this.returnPlan = returnPlan;
    }

    public void setReturnQtext(Boolean returnQtext) {
        this.returnQtext = returnQtext;
    }

    public void setReturnQuery(Boolean returnQuery) {
        this.returnQuery = returnQuery;
    }

    public void setReturnResults(Boolean returnResults) {
        this.returnResults = returnResults;
    }

    public void setReturnSimilar(Boolean returnSimilar) {
        this.returnSimilar = returnSimilar;
    }

    public void setReturnValues(Boolean returnValues) {
        this.returnValues = returnValues;
    }

    public void setSearchableExpression(QuerySearchableExpression searchableExpression) {
        this.searchableExpression = searchableExpression;
        this.setSearchableExpressionNamespaceContext(this.searchableExpression.getBindings());
    }

    public void setSearchableExpressionNamespaceContext(EditableNamespaceContext context) {
        ExpressionNamespaceBindings bindings = new ExpressionNamespaceBindings();
        for (String pfx : context.getAllPrefixes()) {
            String uri = context.getNamespaceURI(pfx);
            bindings.addBinding(pfx, uri);
        }
        this.searchableExpressionBindings = bindings;
    }

    public void setSearchOptions(List<String> searchOptions) {
        this.searchOptions = new ArrayList<String>();
        if (searchOptions != null) {
            this.searchOptions.addAll(searchOptions);
        }
    }

    public void setSortOrders(List<QuerySortOrder> sortOrders) {
        this.sortOrders = new ArrayList<QuerySortOrder>();
        this.sortOrders.addAll(sortOrders);
    }

    public void setSuggestionSources(List<QuerySuggestionSource> suggestionSourceOptions) {
        this.suggestionSources = suggestionSourceOptions;
    }

    public void setTerm(QueryTerm termConfig) {
        this.termConfig = termConfig;
    }

    public void setTransformResults(QueryTransformResults transformResultsOption) {
        this.transformResultsOption = transformResultsOption;
    }

    public void patchBindings() {
        for (QueryConstraint constraint : this.queryConstraints) {
            QueryRange range;
            PathIndex index;
            if (constraint.range == null || (index = (range = constraint.range).getPathIndex()) == null || index.bindings == null) continue;
            ExpressionNamespaceBindings bindings = new ExpressionNamespaceBindings();
            for (ExpressionNamespaceBinding binding : index.bindings) {
                bindings.addBinding(binding.getPrefix(), binding.getNamespaceURI());
            }
            range.setPathIndexNamespaceBindings(bindings);
        }
    }

    public void setConstraints(List<QueryConstraint> constraints) {
        this.queryConstraints = new ArrayList<QueryConstraint>();
        this.queryConstraints.addAll(constraints);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class XQueryExtension {
        @XmlAttribute
        private String apply;
        @XmlAttribute
        private String at;
        @XmlAttribute
        private String ns;

        public XQueryExtension() {
        }

        public XQueryExtension(String apply, String ns, String at) {
            this.setApply(apply);
            this.setAt(at);
            this.setNs(ns);
        }

        public String getApply() {
            return this.apply;
        }

        public String getAt() {
            return this.at;
        }

        public String getNs() {
            return this.ns;
        }

        public void setApply(String apply) {
            this.apply = apply;
        }

        public void setAt(String at) {
            this.at = at;
        }

        public void setNs(String ns) {
            this.ns = ns;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ExpressionNamespaceBinding {
        @XmlAttribute(name="prefix")
        String prefix;
        @XmlAttribute(name="namespace-uri")
        String uri;

        public ExpressionNamespaceBinding() {
        }

        public ExpressionNamespaceBinding(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespaceURI() {
            return this.uri;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ExpressionNamespaceBindings {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="binding")
        private List<ExpressionNamespaceBinding> bindings = new ArrayList<ExpressionNamespaceBinding>();

        public void addBinding(String prefix, String uri) {
            this.bindings.add(new ExpressionNamespaceBinding(prefix, uri));
        }

        public ExpressionNamespaceBinding[] toArray() {
            return this.bindings.toArray(new ExpressionNamespaceBinding[0]);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class Aggregate {
        @XmlAttribute
        private String apply;
        @XmlAttribute
        private String udf;

        public String getApply() {
            return this.apply;
        }

        public String getUdf() {
            return this.udf;
        }

        public void setApply(String apply) {
            this.apply = apply;
        }

        public void setUdf(String udf) {
            this.udf = udf;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryValues
    implements Annotatable<QueryValues> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="aggregate")
        private Aggregate aggregate;
        @XmlAttribute
        private String name;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="values-option")
        private List<String> valuesOptions;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="field")
        private Field field;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="uri")
        private String uri;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="json-key")
        private JsonKey jsonKey;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="collection")
        private QueryCollection collection;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-attr-pair")
        private QueryGeospatialAttributePair geoAttrPair;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elem")
        private QueryGeospatialElement geoElem;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elem-pair")
        private QueryGeospatialElementPair geoElemPair;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="range")
        private QueryRange range;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations = new ArrayList<QueryAnnotation>();

        public JsonKey getJsonKey() {
            return this.jsonKey;
        }

        public void setRange(QueryRange queryRange) {
            this.range = queryRange;
        }

        public void setCollection(QueryCollection collection) {
            this.collection = collection;
        }

        public QueryCollection getCollection() {
            return this.collection;
        }

        public QueryGeospatialAttributePair getGeoAttrPair() {
            return this.geoAttrPair;
        }

        public QueryGeospatialElement getGeoElem() {
            return this.geoElem;
        }

        public QueryGeospatialElementPair getGeoElemPair() {
            return this.geoElemPair;
        }

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public QueryValues annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public QueryValues() {
            this.valuesOptions = new ArrayList<String>();
        }

        public void setJsonKey(JsonKey jsonKey) {
            this.jsonKey = jsonKey;
        }

        public String getJsonKeyName() {
            return this.jsonKey.getName();
        }

        public QueryValues(String name) {
            this();
            this.name = name;
        }

        public void addValuesOption(String valuesOption) {
            this.valuesOptions.add(valuesOption);
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }

        public Field getField() {
            return this.field;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }

        public List<String> getValuesOptions() {
            return this.valuesOptions;
        }

        public void setAggregate(Aggregate aggregate) {
            this.aggregate = aggregate;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUri() {
            this.uri = "";
        }

        public void setValuesOptions(List<String> valuesOptions) {
            this.valuesOptions = valuesOptions;
        }

        public QueryRange getRange() {
            return this.range;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryTuples
    implements Annotatable<QueryTuples> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="aggregate")
        private Aggregate aggregate;
        @XmlAttribute
        private String name;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="values-option")
        private List<String> valuesOptions;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="field")
        private List<Field> field;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="uri")
        private String uri;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="json-key")
        private List<JsonKey> jsonKey;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="collection")
        private QueryCollection collection;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-attr-pair")
        private List<QueryGeospatialAttributePair> geoAttrPair;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elem")
        private List<QueryGeospatialElement> geoElem;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elem-pair")
        private List<QueryGeospatialElementPair> geoElemPair;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="range")
        private List<QueryRange> range;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations = new ArrayList<QueryAnnotation>();

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public QueryTuples annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public QueryTuples() {
            this.field = new ArrayList<Field>();
            this.jsonKey = new ArrayList<JsonKey>();
            this.geoAttrPair = new ArrayList<QueryGeospatialAttributePair>();
            this.geoElem = new ArrayList<QueryGeospatialElement>();
            this.geoElemPair = new ArrayList<QueryGeospatialElementPair>();
            this.range = new ArrayList<QueryRange>();
            this.valuesOptions = new ArrayList<String>();
        }

        public void addRange(QueryRange queryRange) {
            this.range.add(queryRange);
        }

        public void setCollection(QueryCollection collection) {
            this.collection = collection;
        }

        public List<JsonKey> getJsonKey() {
            return this.jsonKey;
        }

        public QueryCollection getCollection() {
            return this.collection;
        }

        public List<QueryGeospatialAttributePair> getGeoAttrPair() {
            return this.geoAttrPair;
        }

        public List<QueryGeospatialElement> getGeoElem() {
            return this.geoElem;
        }

        public List<QueryGeospatialElementPair> getGeoElemPair() {
            return this.geoElemPair;
        }

        public List<QueryRange> getRange() {
            return this.range;
        }

        public void addJsonKey(JsonKey jsonKey) {
            this.jsonKey.add(jsonKey);
        }

        public void addValuesOption(String valuesOption) {
            this.valuesOptions.add(valuesOption);
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }

        public List<Field> getField() {
            return this.field;
        }

        public String getName() {
            return this.name;
        }

        public boolean getUri() {
            return this.uri != null && this.uri.equals("");
        }

        public List<String> getValuesOptions() {
            return this.valuesOptions;
        }

        public void setAggregate(Aggregate aggregate) {
            this.aggregate = aggregate;
        }

        public void addField(Field field) {
            this.field.add(field);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUri() {
            this.uri = "";
        }

        public void setValuesOptions(List<String> valuesOptions) {
            this.valuesOptions = valuesOptions;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class PreferredElements {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="element")
        private List<MarkLogicQName> elements = new ArrayList<MarkLogicQName>();

        public void addElement(MarkLogicQName element) {
            this.elements.add(element);
        }

        public List<MarkLogicQName> getElements() {
            return this.elements;
        }

        public void setElements(List<MarkLogicQName> elements) {
            this.elements = elements;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryTransformResults {
        @XmlAttribute
        private String apply;
        @XmlAttribute
        private String at;
        @XmlAttribute
        private String ns;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="per-match-tokens")
        private Integer perMatchTokens;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="max-matches")
        private Integer maxMatches;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="max-snippet-chars")
        private Integer maxSnippetChars;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="preferred-elements")
        private PreferredElements preferredElements;

        public Integer getPerMatchTokens() {
            return this.perMatchTokens;
        }

        public void setPerMatchTokens(Integer perMatchTokens) {
            this.perMatchTokens = perMatchTokens;
        }

        public Integer getMaxMatches() {
            return this.maxMatches;
        }

        public void setMaxMatches(Integer maxMatches) {
            this.maxMatches = maxMatches;
        }

        public Integer getMaxSnippetChars() {
            return this.maxSnippetChars;
        }

        public void setMaxSnippetChars(Integer maxSnippetChars) {
            this.maxSnippetChars = maxSnippetChars;
        }

        public void addPreferredElement(MarkLogicQName element) {
            if (this.preferredElements == null) {
                this.preferredElements = new PreferredElements();
            }
            this.preferredElements.addElement(element);
        }

        public String getApply() {
            return this.apply;
        }

        public String getAt() {
            return this.at;
        }

        public String getNs() {
            return this.ns;
        }

        public List<MarkLogicQName> getPreferredElements() {
            return this.preferredElements == null ? null : this.preferredElements.getElements();
        }

        public void setApply(String apply) {
            this.apply = apply;
        }

        public void setAt(String at) {
            this.at = at;
        }

        public void setNs(String ns) {
            this.ns = ns;
        }

        public void setPreferredElements(List<MarkLogicQName> elements) {
            this.preferredElements = new PreferredElements();
            this.preferredElements.setElements(elements);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class DefaultTermSource
    implements Annotatable<DefaultTermSource> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="range")
        private QueryRange range;
        @XmlAttribute(name="ref")
        private String ref;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="value")
        private QueryValue value;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="word")
        private QueryWord word;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations = new ArrayList<QueryAnnotation>();

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public DefaultTermSource annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public <T extends BaseConstraintItem> T getSource() {
            if (this.value != null) {
                return (T)this.value;
            }
            if (this.range != null) {
                return (T)this.range;
            }
            if (this.word != null) {
                return (T)this.word;
            }
            return null;
        }

        public void setSource(TermSource constraintDefinition) {
            if (constraintDefinition instanceof QueryValue) {
                this.value = (QueryValue)constraintDefinition;
            } else if (constraintDefinition instanceof QueryWord) {
                this.word = (QueryWord)constraintDefinition;
            } else if (constraintDefinition instanceof QueryRange) {
                this.range = (QueryRange)constraintDefinition;
            }
        }

        public void setRef(String defaultSourceName) {
            this.ref = defaultSourceName;
        }

        public String getRef() {
            return this.ref;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryTerm
    implements TermOptions,
    Annotatable<QueryTerm> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="default")
        private DefaultTermSource defaultConstraint;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="empty")
        private XQueryExtension empty;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="term-option")
        private List<String> termOptions;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="weight")
        private Double weight;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations = new ArrayList<QueryAnnotation>();
        private XQueryExtension xQueryExtension;

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public QueryTerm annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public <T extends BaseConstraintItem> T getSource() {
            if (this.defaultConstraint == null) {
                return null;
            }
            return this.defaultConstraint.getSource();
        }

        public TermApply getEmptyApply() {
            return TermApply.fromXmlString(this.empty.getApply());
        }

        public XQueryExtension getTermFunction() {
            return this.xQueryExtension;
        }

        public void setTermFunction(XQueryExtension extension) {
            this.xQueryExtension = extension;
        }

        @Override
        public List<String> getTermOptions() {
            return this.termOptions;
        }

        @Override
        public Double getWeight() {
            return this.weight;
        }

        public void setSource(TermSource termSource) {
            this.defaultConstraint = new DefaultTermSource();
            this.defaultConstraint.setSource(termSource);
        }

        public void setEmptyApply(TermApply termApply) {
            this.empty = new XQueryExtension();
            this.empty.setApply(termApply.toXmlString());
        }

        @Override
        public void setTermOptions(List<String> termOptions) {
            this.termOptions = termOptions;
        }

        @Override
        public void setWeight(Double weight) {
            this.weight = weight;
        }

        public void setRef(String defaultSourceName) {
            this.defaultConstraint = new DefaultTermSource();
            this.defaultConstraint.setRef(defaultSourceName);
        }

        public String getRef() {
            return this.defaultConstraint.getRef();
        }

        public static enum TermApply {
            ALL_RESULTS,
            NO_RESULTS;


            public static TermApply fromXmlString(String xmlString) {
                return TermApply.valueOf(xmlString.toUpperCase().replace("-", "_"));
            }

            public String toXmlString() {
                return this.toString().toLowerCase().replace("_", "-");
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QuerySortOrder
    implements Indexed,
    Annotatable<QuerySortOrder> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="attribute")
        private MarkLogicQName attributeReference;
        @XmlAttribute
        private String collation;
        @XmlAttribute
        private String direction;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="element")
        private MarkLogicQName elementReference;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="field")
        private Field fieldReference;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="json-key")
        private JsonKey jsonKey;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="score")
        private String score;
        @XmlAttribute
        private String type;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations = new ArrayList<QueryAnnotation>();

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public QuerySortOrder annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public QName getAttribute() {
            return this.attributeReference.asQName();
        }

        public String getCollation() {
            return this.collation;
        }

        public Direction getDirection() {
            return Direction.fromXMLString(this.direction);
        }

        public QName getElement() {
            return this.elementReference.asQName();
        }

        public String getFieldName() {
            return this.fieldReference.getName();
        }

        public String getJsonKey() {
            return this.jsonKey.getName();
        }

        public String getType() {
            return this.type;
        }

        @Override
        public void setAttribute(MarkLogicQName attribute) {
            this.attributeReference = attribute;
        }

        public void setCollation(String collation) {
            this.collation = collation;
        }

        public void setDirection(Direction direction) {
            this.direction = direction.toXMLString();
        }

        @Override
        public void setElement(MarkLogicQName element) {
            this.elementReference = element;
        }

        @Override
        public void setField(Field field) {
            this.fieldReference = field;
        }

        @Override
        public void setPath(PathIndex pathIndex) {
            throw new UnsupportedOperationException("Path indexes are not part of sort orders");
        }

        public void setScore() {
            this.score = "";
        }

        public Score getScore() {
            return this.score != null && this.score.equals("") ? Score.YES : null;
        }

        public void unsetScore() {
            this.score = null;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public void setJsonKey(JsonKey jsonKey) {
            this.jsonKey = jsonKey;
        }

        public static enum Score {
            YES;

        }

        public static enum Direction {
            ASCENDING,
            DESCENDING;


            static Direction fromXMLString(String xmlString) {
                return Direction.valueOf(xmlString.toUpperCase().replace("-", "_"));
            }

            String toXMLString() {
                return this.toString().toLowerCase().replace("_", "-");
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class QueryState {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="additional-query")
        private QueryAdditionalQuery additionalQuery;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="debug")
        private Boolean debug;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="forest")
        private List<Long> forests;
        @XmlAttribute(name="name")
        private String name;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="page-length")
        private Long pageLength;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="quality-weight")
        private Double qualityWeight;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="namespace-bindings")
        private ExpressionNamespaceBindings searchableExpressionBindings;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="searchable-expression")
        private QuerySearchableExpression searchableExpression;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="search-option")
        private List<String> searchOptions;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="sort-order")
        private List<QuerySortOrder> sortOrders = new ArrayList<QuerySortOrder>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="transform-results")
        private QueryTransformResults transformResults;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations;

        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        public QueryState annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public void addForest(Long forest) {
            if (this.forests == null) {
                this.forests = new ArrayList<Long>();
            }
            this.forests.add(forest);
        }

        public void addSortOrder(QuerySortOrder sortOrder) {
            this.sortOrders.add(sortOrder);
        }

        public void deleteSortOrders() {
            this.sortOrders = new ArrayList<QuerySortOrder>();
        }

        public Element getAdditionalQuery() {
            return this.additionalQuery.getValue();
        }

        public Boolean getDebug() {
            return this.debug;
        }

        public List<Long> getForests() {
            return this.forests;
        }

        public String getName() {
            return this.name;
        }

        public Long getPageLength() {
            return this.pageLength;
        }

        public Double getQualityWeight() {
            return this.qualityWeight;
        }

        public QuerySearchableExpression getSearchableExpression() {
            return this.searchableExpression;
        }

        public NamespaceContext getSearchableExpressionNamespaceBindings() {
            EditableNamespaceContext context = new EditableNamespaceContext();
            for (ExpressionNamespaceBinding binding : this.searchableExpressionBindings.bindings) {
                String prefix = binding.getPrefix();
                String uri = binding.getNamespaceURI();
                if ("".equals(prefix)) {
                    context.setDefaultNamespaceURI(uri);
                    continue;
                }
                context.setNamespaceURI(prefix, uri);
            }
            return context;
        }

        public List<String> getSearchOptions() {
            return this.searchOptions;
        }

        public List<QuerySortOrder> getSortOrders() {
            return this.sortOrders;
        }

        public QueryTransformResults getTransformResultsOption() {
            return this.transformResults;
        }

        public QueryState withAdditionalQuery(QueryAdditionalQuery additionalQuery) {
            this.additionalQuery = additionalQuery;
            return this;
        }

        public QueryState withAdditionalQuery(Element element) {
            this.additionalQuery = new QueryAdditionalQuery(element);
            return this;
        }

        public void setDebug(Boolean debug) {
            this.debug = debug;
        }

        public QueryState withForests(List<Long> forests) {
            this.forests = forests;
            return this;
        }

        public void setName(String name) {
            this.name = name;
        }

        public QueryState withPageLength(Long pageLength) {
            this.pageLength = pageLength;
            return this;
        }

        public QueryState withQualityWeight(Double qualityWeight) {
            this.qualityWeight = qualityWeight;
            return this;
        }

        public QueryState withSearchableExpression(QuerySearchableExpression querySearchableExpression) {
            this.searchableExpression = querySearchableExpression;
            return this;
        }

        public QueryState withSearchOptions(List<String> searchOptions) {
            this.searchOptions = searchOptions;
            return this;
        }

        public QueryState withSortOrders(QuerySortOrder ... sortOrders) {
            this.sortOrders = Arrays.asList(sortOrders);
            return this;
        }

        public QueryState withTransformResults(QueryTransformResults transformResults) {
            this.transformResults = transformResults;
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryOperator
    implements Annotatable<QueryOperator> {
        @XmlAttribute
        private String name;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="state")
        private List<QueryState> states;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations = new ArrayList<QueryAnnotation>();

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public QueryOperator annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public QueryOperator() {
            this.states = new ArrayList<QueryState>();
        }

        public String getName() {
            return this.name;
        }

        public List<QueryState> getStates() {
            return this.states;
        }

        public void addState(QueryState state) {
            this.states.add(state);
        }

        public void setName(String name) {
            this.name = name;
        }

        public QueryState getState(String name) {
            for (QueryState state : this.getStates()) {
                if (!state.getName().equals(name)) continue;
                return state;
            }
            return null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class QueryGrammar {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="implicit")
        private QueryAdditionalQuery implicit;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="joiner")
        private List<QueryJoiner> joiners = new ArrayList<QueryJoiner>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="quotation")
        private String quotation;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="starter")
        private List<QueryStarter> starters = new ArrayList<QueryStarter>();

        public void addJoiner(QueryJoiner joiner) {
            this.joiners.add(joiner);
        }

        public void addStarter(QueryStarter starter) {
            this.starters.add(starter);
        }

        public Element getImplicit() {
            return this.implicit.getValue();
        }

        public List<QueryJoiner> getJoiners() {
            return this.joiners;
        }

        public void setJoiners(List<QueryJoiner> joiners) {
            this.joiners = joiners;
        }

        public String getQuotation() {
            return this.quotation;
        }

        public void setStarters(List<QueryStarter> starters) {
            this.starters = starters;
        }

        public List<QueryStarter> getStarters() {
            return this.starters;
        }

        public void setImplicit(Element implicit) {
            this.implicit = new QueryAdditionalQuery(implicit);
        }

        public void setQuotation(String quotation) {
            this.quotation = quotation;
        }

        public static enum Tokenize {
            DEFAULT,
            WORD;


            static Tokenize fromXMLString(String xmlString) {
                return Tokenize.valueOf(xmlString.toUpperCase().replace("-", "_"));
            }

            String toXMLString() {
                return this.toString().toLowerCase().replace("_", "-");
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static final class QueryStarter {
            @XmlAttribute
            private String apply;
            @XmlAttribute
            private String delimiter;
            @XmlAttribute
            private String element;
            @XmlAttribute
            private String options;
            @XmlValue
            private String starterText;
            @XmlAttribute
            private int strength;
            @XmlAttribute
            private String tokenize;

            public QueryStarter() {
            }

            public QueryStarter(String starterText) {
                this.starterText = starterText;
            }

            public StarterApply getApply() {
                return StarterApply.fromXMLString(this.apply);
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public String getElement() {
                return this.element;
            }

            public String getOptions() {
                return this.options;
            }

            public String getStarterText() {
                return this.starterText;
            }

            public int getStrength() {
                return this.strength;
            }

            public Tokenize getTokenize() {
                return Tokenize.fromXMLString(this.tokenize);
            }

            public void setApply(StarterApply apply) {
                this.apply = apply.toXMLString();
            }

            public void setApply(String apply) {
                this.apply = apply;
            }

            public void setDelimiter(String delimiter) {
                this.delimiter = delimiter;
            }

            public void setElement(String element) {
                this.element = element;
            }

            public void setOptions(String options) {
                this.options = options;
            }

            public void setStrength(int strength) {
                this.strength = strength;
            }

            public void setStarterText(String starterText) {
                this.starterText = starterText;
            }

            public void setTokenize(String tokenize) {
                this.tokenize = tokenize;
            }

            public static enum StarterApply {
                GROUPING,
                PREFIX;


                static StarterApply fromXMLString(String xmlString) {
                    return StarterApply.valueOf(xmlString.toUpperCase().replace("-", "_"));
                }

                String toXMLString() {
                    return this.toString().toLowerCase().replace("_", "-");
                }
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static final class QueryJoiner {
            @XmlAttribute
            private String apply;
            @XmlAttribute
            private String compare;
            @XmlAttribute
            private int consume;
            @XmlAttribute
            private String delimiter;
            @XmlAttribute
            private String element;
            @XmlValue
            private String joinerText;
            @XmlAttribute
            private String options;
            @XmlAttribute
            private int strength;
            @XmlAttribute
            private String tokenize;

            public QueryJoiner() {
            }

            public QueryJoiner(String joinerText) {
                this.joinerText = joinerText;
            }

            public JoinerApply getApply() {
                return JoinerApply.valueOf(this.apply.toUpperCase());
            }

            public Comparator getComparator() {
                return Comparator.valueOf(this.compare);
            }

            public int getConsume() {
                return this.consume;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public String getElement() {
                return this.element;
            }

            public String getJoinerText() {
                return this.joinerText;
            }

            public String getOptions() {
                return this.options;
            }

            public int getStrength() {
                return this.strength;
            }

            public Tokenize getTokenize() {
                return Tokenize.valueOf(this.tokenize.toUpperCase());
            }

            public void setApply(JoinerApply apply) {
                this.apply = apply.toXMLString();
            }

            public void setApply(String apply) {
                this.apply = apply;
            }

            public void setCompare(Comparator compare) {
                this.compare = compare.toString();
            }

            public void setConsume(int consume) {
                this.consume = consume;
            }

            public void setElement(String element) {
                this.element = element;
            }

            public void setStrength(int strength) {
                this.strength = strength;
            }

            public void setTokenize(Tokenize tokenize) {
                this.tokenize = tokenize.toXMLString();
            }

            public static enum JoinerApply {
                CONSTRAINT,
                INFIX,
                NEAR2,
                PREFIX;


                static JoinerApply fromXMLString(String xmlString) {
                    return JoinerApply.valueOf(xmlString.toUpperCase().replace("-", "_"));
                }

                String toXMLString() {
                    return this.toString().toLowerCase().replace("_", "-");
                }
            }

            public static enum Comparator {
                EQ,
                GE,
                GT,
                LE,
                LT,
                NE;

            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class WordLexicon {
        @XmlAttribute
        private String collation;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="fragment-scope")
        private FragmentScope fragmentScope;

        public String getCollation() {
            return this.collation;
        }

        public FragmentScope getFragmentScope() {
            return this.fragmentScope;
        }

        public void setCollation(String collation) {
            this.collation = collation;
        }

        public void setFragmentScope(FragmentScope fragmentScope) {
            this.fragmentScope = fragmentScope;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class QueryDefaultSuggestionSource
    extends QuerySuggestionSource {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QuerySuggestionSource
    implements Annotatable<QuerySuggestionSource> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations = new ArrayList<QueryAnnotation>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="collection")
        private QueryCollection collection;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="custom")
        private QueryCustom custom;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="element-query")
        private QueryElementQuery elementQuery;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-attrName-pair")
        private QueryGeospatialAttributePair geoAttrPair;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elemName")
        private QueryGeospatialElement geoElem;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elemName-pair")
        private QueryGeospatialElementPair geoElemPair;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="properties")
        private QueryProperties properties;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="range")
        private QueryRange range;
        @XmlAttribute
        private String ref;
        @XmlElement(name="suggestion-option")
        private List<String> suggestionOptions = new ArrayList<String>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="value")
        private QueryValue value;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="word")
        private QueryWord word;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="word-lexicon")
        private WordLexicon wordLexicon;

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public QuerySuggestionSource annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public void addSuggestionOption(String suggestionOption) {
            this.suggestionOptions.add(suggestionOption);
        }

        public void deleteSuggestionOptions() {
            this.suggestionOptions = new ArrayList<String>();
        }

        public <T extends BaseConstraintItem> T getConstraintConfiguration() {
            if (this.collection != null) {
                return (T)this.collection;
            }
            if (this.value != null) {
                return (T)this.value;
            }
            if (this.range != null) {
                return (T)this.range;
            }
            if (this.word != null) {
                return (T)this.word;
            }
            if (this.elementQuery != null) {
                return (T)this.elementQuery;
            }
            if (this.properties != null) {
                return (T)this.properties;
            }
            if (this.custom != null) {
                return (T)this.custom;
            }
            if (this.geoElem != null) {
                return (T)this.geoElem;
            }
            if (this.geoAttrPair != null) {
                return (T)this.geoAttrPair;
            }
            if (this.geoElemPair != null) {
                return (T)this.geoElemPair;
            }
            return null;
        }

        public String getRef() {
            return this.ref;
        }

        public List<String> getSuggestionOptions() {
            return this.suggestionOptions;
        }

        public WordLexicon getWordLexicon() {
            return this.wordLexicon;
        }

        public <T extends BaseConstraintItem> void setImplementation(T constraintDefinition) {
            if (constraintDefinition.getClass() == QueryCollection.class) {
                this.collection = (QueryCollection)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryValue.class) {
                this.value = (QueryValue)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryWord.class) {
                this.word = (QueryWord)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryRange.class) {
                this.range = (QueryRange)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryElementQuery.class) {
                this.elementQuery = (QueryElementQuery)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryProperties.class) {
                this.properties = (QueryProperties)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryCustom.class) {
                this.custom = (QueryCustom)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryGeospatialElement.class) {
                this.geoElem = (QueryGeospatialElement)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryGeospatialAttributePair.class) {
                this.geoAttrPair = (QueryGeospatialAttributePair)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryGeospatialElementPair.class) {
                this.geoElemPair = (QueryGeospatialElementPair)constraintDefinition;
            }
        }

        public void setRef(String constraintReference) {
            this.ref = constraintReference;
        }

        public void setWordLexicon(WordLexicon wordLexicon) {
            this.wordLexicon = wordLexicon;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryAnnotation {
        @XmlAnyElement
        private List<Element> annotations = new ArrayList<Element>();

        public QueryAnnotation() {
        }

        public QueryAnnotation(String xmlString) {
            this.annotations.add(Utilities.domElement(xmlString));
        }

        public void add(Element value) {
            this.annotations.add(value);
        }

        public Element get(int i) {
            return this.annotations.get(i);
        }

        public List<Element> getAll() {
            return this.annotations;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ConstraintValue
    implements MetadataExtract {
        @XmlAttribute
        private String ref;

        public ConstraintValue() {
        }

        public ConstraintValue(String constraintReference) {
            this.ref = constraintReference;
        }

        @Override
        public void build(QueryExtractMetadata extractMetadata) {
            extractMetadata.addConstraintReference(this);
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class AttributeValue
    extends AttributeOrElementValue
    implements MetadataExtract {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class ElementValue
    extends AttributeOrElementValue
    implements MetadataExtract {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class AttributeOrElementValue {
        @XmlAttribute(name="elem-ns")
        private String elemNs;
        @XmlAttribute(name="attr-ns")
        private String attrNs;
        @XmlAttribute(name="elem-name")
        private String elemName;
        @XmlAttribute(name="attr-name")
        private String attrName;

        public String getElemNs() {
            return this.elemNs;
        }

        public void setElemNs(String elem_ns) {
            this.elemNs = elem_ns;
        }

        public String getAttrNs() {
            return this.attrNs;
        }

        public void setAttrNs(String attr_ns) {
            this.attrNs = attr_ns;
        }

        public String getElemName() {
            return this.elemName;
        }

        public void setElemName(String elem) {
            this.elemName = elem;
        }

        public String getAttrName() {
            return this.attrName;
        }

        public void setAttrName(String attr) {
            this.attrName = attr;
        }

        public void build(QueryExtractMetadata extractMetadata) {
            extractMetadata.getQNames().add(this);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class MarkLogicQName {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String ns;

        public MarkLogicQName() {
        }

        public MarkLogicQName(String ns, String name) {
            this.ns = ns == null ? "" : ns;
            this.name = name;
        }

        public QName asQName() {
            return new QName(this.getNs(), this.getName());
        }

        public String getName() {
            return this.name;
        }

        public String getNs() {
            return this.ns;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryExtractMetadata {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="qname")
        private List<AttributeOrElementValue> qnames = new ArrayList<AttributeOrElementValue>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="constraint-value")
        private List<ConstraintValue> constraintValues = new ArrayList<ConstraintValue>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="json-key")
        private List<JsonKey> jsonKeys = new ArrayList<JsonKey>();

        public void addConstraintReference(ConstraintValue constraintValue) {
            this.constraintValues.add(constraintValue);
        }

        public List<AttributeOrElementValue> getQNames() {
            return this.qnames;
        }

        public List<ConstraintValue> getConstraintValues() {
            return this.constraintValues;
        }

        public List<JsonKey> getJsonKeys() {
            return this.jsonKeys;
        }
    }

    public static enum FragmentScope {
        DOCUMENTS,
        PROPERTIES;

    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Field
    implements TupleSource {
        @XmlAttribute
        private String name;

        public Field() {
        }

        public Field(String name) {
            this.name = name;
        }

        @Override
        public void build(QueryTuples tuples) {
            tuples.addField(this);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void build(Indexed indexable) {
            indexable.setField(this);
        }

        @Override
        public void build(QueryValues values) {
            values.setField(this);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class JsonKey
    implements MetadataExtract {
        @XmlValue
        private String name;

        public JsonKey() {
        }

        public JsonKey(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void build(QueryExtractMetadata extractMetadata) {
            extractMetadata.getJsonKeys().add(this);
        }

        public void build(QueryValues values) {
            values.setJsonKey(this);
        }

        public void build(QueryTuples values) {
            values.addJsonKey(this);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class PathIndex {
        @XmlTransient
        private ExpressionNamespaceBinding[] bindings = null;
        @XmlValue
        private String path = null;

        public PathIndex() {
        }

        public PathIndex(String path) {
            this.path = path;
        }

        public PathIndex(String path, ExpressionNamespaceBinding ... bindings) {
            this.path = path;
            this.bindings = bindings;
        }

        public String getPath() {
            return this.path;
        }

        public ExpressionNamespaceBinding[] getBindings() {
            return this.bindings;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryAdditionalQuery {
        @XmlAnyElement
        private Element element;

        public QueryAdditionalQuery() {
        }

        public QueryAdditionalQuery(Element ctsQuery) {
            this.element = ctsQuery;
        }

        public Element getValue() {
            return this.element;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QuerySearchableExpression {
        @XmlTransient
        private ExpressionNamespaceBinding[] bindings = null;
        @XmlValue
        private String path = null;

        public QuerySearchableExpression() {
        }

        public QuerySearchableExpression(String path, ExpressionNamespaceBinding ... bindings) {
            this.path = path;
            this.bindings = bindings;
        }

        public String getPath() {
            return this.path;
        }

        public ExpressionNamespaceBinding[] getBindings() {
            return this.bindings;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Heatmap {
        @XmlAttribute
        private double e;
        @XmlAttribute
        private int latdivs;
        @XmlAttribute
        private int londivs;
        @XmlAttribute
        private double n;
        @XmlAttribute
        private double s;
        @XmlAttribute
        private double w;

        public double getE() {
            return this.e;
        }

        public int getLatdivs() {
            return this.latdivs;
        }

        public int getLondivs() {
            return this.londivs;
        }

        public double getN() {
            return this.n;
        }

        public double getS() {
            return this.s;
        }

        public double getW() {
            return this.w;
        }

        public Heatmap setE(double e) {
            this.e = e;
            return this;
        }

        public Heatmap setLatdivs(int latdivs) {
            this.latdivs = latdivs;
            return this;
        }

        public Heatmap setLondivs(int londivs) {
            this.londivs = londivs;
            return this;
        }

        public Heatmap setN(double n) {
            this.n = n;
            return this;
        }

        public Heatmap setS(double s) {
            this.s = s;
            return this;
        }

        public Heatmap setW(double w) {
            this.w = w;
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryGeospatialElementPair
    extends QueryGeospatial {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryGeospatialElement
    extends QueryGeospatial {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryGeospatialAttributePair
    extends QueryGeospatial {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static abstract class QueryGeospatial
    extends BaseConstraintItem
    implements ConstraintSource {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="facet-option")
        private List<String> facetOptions;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-option")
        private List<String> geoOptions = new ArrayList<String>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="heatmap")
        private Heatmap heatmap;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="lat")
        private MarkLogicQName latitude;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="lon")
        private MarkLogicQName longitude;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="parent")
        private MarkLogicQName parent;

        public QueryGeospatial() {
            this.facetOptions = new ArrayList<String>();
        }

        public void addFacetOption(String facetOption) {
            this.facetOptions.add(facetOption);
        }

        public void addGeoOption(String geoOption) {
            this.geoOptions.add(geoOption);
        }

        public List<String> getFacetOptions() {
            return this.facetOptions;
        }

        public Heatmap getHeatmap() {
            return this.heatmap;
        }

        public MarkLogicQName getLatitude() {
            return this.latitude;
        }

        public MarkLogicQName getLongitude() {
            return this.longitude;
        }

        public MarkLogicQName getParent() {
            return this.parent;
        }

        public void setGeoOptions(List<String> geoOptions) {
            this.geoOptions = geoOptions;
        }

        public void setHeatmap(Heatmap heatmap) {
            this.heatmap = heatmap;
        }

        public void setLatitude(MarkLogicQName latitude) {
            this.latitude = latitude;
        }

        public void setLongitude(MarkLogicQName longitude) {
            this.longitude = longitude;
        }

        public void setParent(MarkLogicQName parent) {
            this.parent = parent;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryElementQuery
    extends BaseConstraintItem
    implements ConstraintSource {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String ns;

        public String getName() {
            return this.name;
        }

        public String getNs() {
            return this.ns;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNs(String ns) {
            this.ns = ns;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class QueryProperties
    extends BaseConstraintItem
    implements ConstraintSource {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryCollection
    extends FacetableConstraintConfiguration
    implements TupleSource,
    ConstraintSource {
        @XmlAttribute
        private String prefix;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void build(QueryTuples tuples) {
            tuples.setCollection(this);
        }

        @Override
        public void build(QueryValues values) {
            values.setCollection(this);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class QueryWord
    extends BaseConstraintItem
    implements TermSource,
    ConstraintSource,
    TermIndexed {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class QueryRange
    extends FacetableConstraintConfiguration
    implements TupleSource,
    ConstraintSource,
    RangeIndexed,
    TermSource {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="bucket")
        private List<Bucket> buckets = new ArrayList<Bucket>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="computed-bucket")
        private List<ComputedBucket> computedBuckets = new ArrayList<ComputedBucket>();

        public void addBucket(Bucket bucket) {
            this.buckets.add(bucket);
        }

        public QueryRange addComputedBucket(ComputedBucket computedBucket) {
            this.computedBuckets.add(computedBucket);
            return this;
        }

        public void deleteBuckets() {
            this.computedBuckets = new ArrayList<ComputedBucket>();
            this.buckets = new ArrayList<Bucket>();
        }

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public List<ComputedBucket> getComputedBuckets() {
            return this.computedBuckets;
        }

        public void addBuckets(List<Buckets> buckets) {
            if (buckets != null) {
                for (Buckets b : buckets) {
                    if (buckets.get(0).getClass() == Bucket.class) {
                        this.addBucket((Bucket)b);
                        continue;
                    }
                    this.addComputedBucket((ComputedBucket)b);
                }
            }
        }

        @Override
        public void build(QueryTuples tuples) {
            tuples.addRange(this);
        }

        @Override
        public void build(QueryValues values) {
            values.setRange(this);
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class ComputedBucket
        implements Buckets {
            @XmlAttribute(name="anchor")
            private String anchor;
            @XmlAttribute
            private String ge;
            @XmlAttribute(name="ge-anchor")
            private String geAnchor;
            @XmlValue
            private String label;
            @XmlAttribute
            private String lt;
            @XmlAttribute(name="lt-anchor")
            private String ltAnchor;
            @XmlAttribute
            private String name;

            public String getAnchor() {
                return this.anchor;
            }

            public AnchorValue getAnchorValue() {
                return AnchorValue.fromXmlString(this.anchor);
            }

            public String getGe() {
                return this.ge;
            }

            public String getGeAnchor() {
                return this.geAnchor;
            }

            public String getLabel() {
                return this.label;
            }

            public String getLt() {
                return this.lt;
            }

            public String getLtAnchor() {
                return this.ltAnchor;
            }

            public String getName() {
                return this.name;
            }

            public void setAnchor(AnchorValue anchorValue) {
                this.anchor = anchorValue.toXmlString();
            }

            public void setGe(String ge) {
                this.ge = ge;
            }

            public void setLabel(String content) {
                this.label = content;
            }

            public void setLt(String lt) {
                this.lt = lt;
            }

            public void setName(String name) {
                this.name = name;
            }

            public static enum AnchorValue {
                NOW,
                START_OF_DAY,
                START_OF_MONTH,
                START_OF_YEAR;


                static AnchorValue fromXmlString(String xmlString) {
                    return AnchorValue.valueOf(xmlString.toUpperCase().replace("-", "_"));
                }

                String toXmlString() {
                    return this.toString().toLowerCase().replace("_", "-");
                }
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class Bucket
        implements Buckets {
            @XmlValue
            private String content;
            @XmlAttribute
            private String ge;
            @XmlAttribute
            private String lt;
            @XmlAttribute
            private String name;

            public String getContent() {
                return this.content;
            }

            public String getGe() {
                return this.ge;
            }

            public String getLt() {
                return this.lt;
            }

            public String getName() {
                return this.name;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public void setGe(String ge) {
                this.ge = ge;
            }

            public void setLt(String lt) {
                this.lt = lt;
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryCustom
    extends FacetableConstraintConfiguration
    implements TermOptions,
    ConstraintSource,
    Annotatable<QueryCustom> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="finish-facet")
        private XQueryExtension finishFacet;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="parse")
        private XQueryExtension parse;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="start-facet")
        private XQueryExtension startFacet;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations;

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public QueryCustom annotate(String xmlString) {
            this.annotations.add(new QueryAnnotation(xmlString));
            return this;
        }

        public QueryCustom(boolean doFacets) {
            this.doFacets(doFacets);
        }

        public QueryCustom(boolean doFacets, XQueryExtension parseExtension) {
            this.doFacets(doFacets);
            this.parse = parseExtension;
        }

        QueryCustom() {
            this.annotations = new ArrayList<QueryAnnotation>();
        }

        public XQueryExtension getFinishFacet() {
            return this.finishFacet;
        }

        public XQueryExtension getParse() {
            return this.parse;
        }

        public XQueryExtension getStartFacet() {
            return this.startFacet;
        }

        public void setFinishFacet(XQueryExtension finishFacet) {
            this.finishFacet = finishFacet;
        }

        public void setParse(XQueryExtension parse) {
            this.parse = parse;
        }

        public void setStartFacet(XQueryExtension startFacet) {
            this.startFacet = startFacet;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class QueryValue
    extends BaseConstraintItem
    implements ConstraintSource,
    TermIndexed,
    TermSource {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static abstract class FacetableConstraintConfiguration
    extends BaseConstraintItem {
        @XmlAttribute
        private String collation;
        @XmlAttribute(name="facet")
        private Boolean doFacets;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="facet-option")
        private List<String> facetOptions = new ArrayList<String>();
        @XmlAttribute
        private String type;

        public void addFacetOption(String facetOption) {
            this.facetOptions.add(facetOption);
        }

        public void doFacets(Boolean doFacets) {
            this.doFacets = doFacets;
        }

        public String getCollation() {
            return this.collation;
        }

        public Boolean getDoFacets() {
            return this.doFacets;
        }

        public List<String> getFacetOptions() {
            return this.facetOptions;
        }

        public String getType() {
            return this.type;
        }

        public void setCollation(String collation) {
            this.collation = collation;
        }

        public void setDoFacets(boolean doFacets) {
            this.doFacets = doFacets;
        }

        public void setFacetOptions(List<String> facetOptions) {
            this.facetOptions = new ArrayList<String>();
            for (String option : facetOptions) {
                this.facetOptions.add(option);
            }
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static abstract class BaseConstraintItem {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="attribute")
        private MarkLogicQName attributeReference;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="element")
        private MarkLogicQName elementReference;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="field")
        private Field fieldReference;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="json-key")
        private JsonKey jsonKey;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="namespace-bindings")
        private ExpressionNamespaceBindings pathIndexBindings;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="path-index")
        private PathIndex pathIndexReference;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="fragment-scope")
        private String fragmentScope;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="term-option")
        private List<String> termOptions = new ArrayList<String>();
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="weight")
        private Double weight = null;

        public void addTermOption(String termOption) {
            this.termOptions.add(termOption);
        }

        public QName getAttribute() {
            return this.attributeReference.asQName();
        }

        public QName getElement() {
            return this.elementReference.asQName();
        }

        public String getPath() {
            if (this.pathIndexReference != null) {
                return this.pathIndexReference.getPath();
            }
            return null;
        }

        public NamespaceContext getPathNamespaceBindings() {
            if (this.pathIndexBindings == null) {
                return null;
            }
            EditableNamespaceContext context = new EditableNamespaceContext();
            for (ExpressionNamespaceBinding binding : this.pathIndexBindings.bindings) {
                String prefix = binding.getPrefix();
                String uri = binding.getNamespaceURI();
                if ("".equals(prefix)) {
                    context.setDefaultNamespaceURI(uri);
                    continue;
                }
                context.setNamespaceURI(prefix, uri);
            }
            return context;
        }

        protected void setPathIndexNamespaceBindings(ExpressionNamespaceBindings bindings) {
            this.pathIndexBindings = bindings;
        }

        public PathIndex getPathIndex() {
            return this.pathIndexReference;
        }

        public String getFieldName() {
            if (this.fieldReference != null) {
                return this.fieldReference.getName();
            }
            return null;
        }

        public String getJsonKeyName() {
            return this.jsonKey.getName();
        }

        public FragmentScope getFragmentScope() {
            if (this.fragmentScope != null) {
                return FragmentScope.valueOf(this.fragmentScope.toUpperCase());
            }
            return null;
        }

        public List<String> getTermOptions() {
            return this.termOptions;
        }

        public Double getWeight() {
            return this.weight;
        }

        public void setAttribute(MarkLogicQName attribute) {
            this.attributeReference = attribute;
        }

        public void setElement(MarkLogicQName element) {
            this.elementReference = element;
        }

        public void setField(Field field) {
            this.fieldReference = field;
        }

        public void setPath(PathIndex pathIndex) {
            this.pathIndexReference = pathIndex;
        }

        public void setJsonKey(JsonKey jsonKey) {
            this.jsonKey = jsonKey;
        }

        public void setFragmentScope(FragmentScope fragmentScope) {
            if (fragmentScope != null) {
                this.fragmentScope = fragmentScope.toString().toLowerCase();
            }
        }

        public void setTermOptions(List<String> termOptions) {
            this.termOptions = new ArrayList<String>();
            this.termOptions.addAll(termOptions);
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class QueryConstraint
    implements Annotatable<QueryConstraint> {
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="annotation", required=false)
        private List<QueryAnnotation> annotations;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="collection")
        private QueryCollection collection;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="custom")
        private QueryCustom custom;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="element-query")
        private QueryElementQuery elementQuery;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-attr-pair")
        private QueryGeospatialAttributePair geoAttrPair;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elem")
        private QueryGeospatialElement geoElem;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="geo-elem-pair")
        private QueryGeospatialElementPair geoElemPair;
        @XmlAttribute
        private String name;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="properties")
        private QueryProperties properties;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="range")
        private QueryRange range;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="value")
        private QueryValue value;
        @XmlElement(namespace="http://marklogic.com/appservices/search", name="word")
        private QueryWord word;

        public QueryConstraint() {
        }

        public QueryConstraint(String name) {
            this();
            this.annotations = new ArrayList<QueryAnnotation>();
            this.setName(name);
        }

        @Override
        public List<QueryAnnotation> getAnnotations() {
            return this.annotations;
        }

        public String getName() {
            return this.name;
        }

        public <T extends BaseConstraintItem> T getSource() {
            if (this.collection != null) {
                return (T)this.collection;
            }
            if (this.value != null) {
                return (T)this.value;
            }
            if (this.range != null) {
                return (T)this.range;
            }
            if (this.word != null) {
                return (T)this.word;
            }
            if (this.elementQuery != null) {
                return (T)this.elementQuery;
            }
            if (this.properties != null) {
                return (T)this.properties;
            }
            if (this.custom != null) {
                return (T)this.custom;
            }
            if (this.geoElem != null) {
                return (T)this.geoElem;
            }
            if (this.geoAttrPair != null) {
                return (T)this.geoAttrPair;
            }
            if (this.geoElemPair != null) {
                return (T)this.geoElemPair;
            }
            return null;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSource(ConstraintSource constraintDefinition) {
            if (constraintDefinition instanceof QueryCollection) {
                this.collection = (QueryCollection)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryValue.class) {
                this.value = (QueryValue)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryWord.class) {
                this.word = (QueryWord)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryRange.class) {
                this.range = (QueryRange)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryElementQuery.class) {
                this.elementQuery = (QueryElementQuery)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryProperties.class) {
                this.properties = (QueryProperties)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryCustom.class) {
                this.custom = (QueryCustom)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryGeospatialElement.class) {
                this.geoElem = (QueryGeospatialElement)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryGeospatialAttributePair.class) {
                this.geoAttrPair = (QueryGeospatialAttributePair)constraintDefinition;
            } else if (constraintDefinition.getClass() == QueryGeospatialElementPair.class) {
                this.geoElemPair = (QueryGeospatialElementPair)constraintDefinition;
            }
        }

        @Override
        public QueryConstraint annotate(String xmlAnnotation) {
            QueryAnnotation annotation = new QueryAnnotation();
            annotation.add(Utilities.domElement(xmlAnnotation));
            this.annotations.add(annotation);
            return this;
        }
    }

    public static enum Facets {
        FACETED,
        UNFACETED;

    }
}

